/*
 * Decompiled with CFR 0.152.
 */
package io.resys.thena.docdb.spi.support;

import io.resys.thena.docdb.api.exceptions.RepoException;
import java.util.function.Supplier;

public class RepoAssert {
    private static final String NAME_PATTER = "^([a-zA-Z0-9 +_/-]|\\\\\\\\)+";

    public static void isName(String value, Supplier<String> message) {
        RepoAssert.isTrue(value.matches(NAME_PATTER), () -> (String)message.get() + " => Valid name pattern: '^([a-zA-Z0-9 +_/-]|\\\\\\\\)+'!");
    }

    public static void notEmpty(String object, Supplier<String> message) {
        if (object == null || object.isBlank()) {
            throw new RepoException(RepoAssert.getMessage(message));
        }
    }

    public static void isEmpty(String object, Supplier<String> message) {
        if (object == null || object.isBlank()) {
            return;
        }
        throw new RepoException(RepoAssert.getMessage(message));
    }

    public static void notNull(Object object, Supplier<String> message) {
        if (object == null) {
            throw new RepoException(RepoAssert.getMessage(message));
        }
    }

    public static void isTrue(boolean expression, Supplier<String> message) {
        if (!expression) {
            throw new RepoException(RepoAssert.getMessage(message));
        }
    }

    private static String getMessage(Supplier<String> supplier) {
        return supplier != null ? supplier.get() : null;
    }
}

