/*
 * Decompiled with CFR 0.152.
 */
package io.resys.thena.docdb.spi.tags;

import io.resys.thena.docdb.api.actions.ImmutableTagResult;
import io.resys.thena.docdb.api.actions.TagActions;
import io.resys.thena.docdb.api.models.ImmutableMessage;
import io.resys.thena.docdb.api.models.ImmutableTag;
import io.resys.thena.docdb.api.models.Message;
import io.resys.thena.docdb.api.models.Objects;
import io.resys.thena.docdb.api.models.Repo;
import io.resys.thena.docdb.spi.ClientState;
import io.resys.thena.docdb.spi.support.RepoAssert;
import io.smallrye.mutiny.Uni;
import java.time.LocalDateTime;

public class CreateTagBuilder
implements TagActions.TagBuilder {
    private final ClientState state;
    private String repoId;
    private String commitIdOrHead;
    private String tagName;
    private String author;
    private String message;

    public CreateTagBuilder(ClientState state) {
        this.state = state;
    }

    @Override
    public TagActions.TagBuilder tagName(String tagName) {
        this.tagName = tagName;
        return this;
    }

    @Override
    public TagActions.TagBuilder repo(String repoId, String commitIdOrHead) {
        this.repoId = repoId;
        this.commitIdOrHead = commitIdOrHead;
        return this;
    }

    @Override
    public TagActions.TagBuilder author(String author) {
        this.author = author;
        return this;
    }

    @Override
    public TagActions.TagBuilder message(String message) {
        this.message = message;
        return this;
    }

    @Override
    public Uni<TagActions.TagResult> build() {
        RepoAssert.notEmpty(this.author, () -> "author can't be empty!");
        RepoAssert.notEmpty(this.message, () -> "message can't be empty!");
        RepoAssert.notEmpty(this.repoId, () -> "repoId can't be empty!");
        RepoAssert.notEmpty(this.commitIdOrHead, () -> "commitIdOrHead can't be empty!");
        RepoAssert.notEmpty(this.tagName, () -> "tagName can't be empty!");
        return this.state.repos().getByNameOrId(this.repoId).onItem().transformToUni(repo -> {
            if (repo == null) {
                return Uni.createFrom().item((Object)ImmutableTagResult.builder().status(TagActions.TagStatus.ERROR).addMessages((Message)ImmutableMessage.builder().text("Can't create tag: '" + this.tagName + "'" + " because there is no repository with id or name: '" + this.repoId + "'!").build()).build());
            }
            ClientState.ClientRepoState ctx = this.state.withRepo((Repo)repo);
            return this.findRef(ctx, this.commitIdOrHead).onItem().transformToUni(ref -> this.findCommit(ctx, ref == null ? this.commitIdOrHead : ref.getCommit())).onItem().transformToUni(commit -> {
                if (commit == null) {
                    return Uni.createFrom().item((Object)ImmutableTagResult.builder().status(TagActions.TagStatus.ERROR).addMessages((Message)ImmutableMessage.builder().text("Can't create tag: '" + this.tagName + "'" + " because there is no commit or head: '" + this.commitIdOrHead + "'!").build()).build());
                }
                return this.findTag(ctx, this.tagName).onItem().transformToUni(existingTag -> {
                    if (existingTag != null) {
                        return Uni.createFrom().item((Object)ImmutableTagResult.builder().status(TagActions.TagStatus.ERROR).addMessages((Message)ImmutableMessage.builder().text("Can't create tag: '" + this.tagName + "'" + " because there is already tag with the same name with commit: '" + existingTag.getCommit() + "'!").build()).build());
                    }
                    return this.createTag(ctx, commit.getId());
                });
            });
        });
    }

    private Uni<Objects.Tag> findTag(ClientState.ClientRepoState state, String tagName) {
        return state.query().tags().name(tagName).get();
    }

    private Uni<Objects.Ref> findRef(ClientState.ClientRepoState state, String refNameOrCommit) {
        return state.query().refs().nameOrCommit(refNameOrCommit);
    }

    private Uni<Objects.Commit> findCommit(ClientState.ClientRepoState state, String commit) {
        return state.query().commits().id(commit);
    }

    private Uni<TagActions.TagResult> createTag(ClientState.ClientRepoState state, String commit) {
        ImmutableTag tag = ImmutableTag.builder().commit(commit).name(this.tagName).message(this.message).author(this.author).dateTime(LocalDateTime.now()).build();
        return state.insert().tag(tag).onItem().transform(inserted -> {
            if (inserted.getDuplicate()) {
                return ImmutableTagResult.builder().status(TagActions.TagStatus.ERROR).tag(tag).addMessages((Message)ImmutableMessage.builder().text("Tag with name:" + " '" + this.tagName + "'" + " is already created.").build()).build();
            }
            return ImmutableTagResult.builder().status(TagActions.TagStatus.OK).tag(tag).build();
        });
    }
}

