/*
 * Decompiled with CFR 0.152.
 */
package io.resys.thena.docdb.sql;

import io.resys.thena.docdb.api.DocDB;
import io.resys.thena.docdb.api.models.Repo;
import io.resys.thena.docdb.spi.ClientCollections;
import io.resys.thena.docdb.spi.ClientInsertBuilder;
import io.resys.thena.docdb.spi.ClientQuery;
import io.resys.thena.docdb.spi.ClientState;
import io.resys.thena.docdb.spi.DocDBDefault;
import io.resys.thena.docdb.spi.ErrorHandler;
import io.resys.thena.docdb.spi.support.RepoAssert;
import io.resys.thena.docdb.sql.ClientQuerySqlPool;
import io.resys.thena.docdb.sql.SqlBuilder;
import io.resys.thena.docdb.sql.SqlMapper;
import io.resys.thena.docdb.sql.builders.ClientInsertBuilderSqlPool;
import io.resys.thena.docdb.sql.builders.RepoBuilderSqlPool;
import io.resys.thena.docdb.sql.defaults.DefaultSqlBuilder;
import io.resys.thena.docdb.sql.defaults.DefaultSqlMapper;
import io.resys.thena.docdb.sql.support.ImmutableSqlClientWrapper;
import io.smallrye.mutiny.Uni;
import io.vertx.mutiny.sqlclient.Pool;

public class DocDBFactorySql {
    public static Builder create() {
        return new Builder();
    }

    public static ClientState state(final ClientCollections ctx, final Pool client, final ErrorHandler handler) {
        return new ClientState(){

            @Override
            public ErrorHandler getErrorHandler() {
                return handler;
            }

            @Override
            public ClientCollections getCollections() {
                return ctx;
            }

            @Override
            public ClientState.RepoBuilder repos() {
                return new RepoBuilderSqlPool(client, ctx, DocDBFactorySql.sqlMapper(ctx), DocDBFactorySql.sqlBuilder(ctx), handler);
            }

            @Override
            public Uni<ClientInsertBuilder> insert(String repoNameOrId) {
                return this.repos().getByNameOrId(repoNameOrId).onItem().transform(repo -> this.insert((Repo)repo));
            }

            @Override
            public ClientInsertBuilder insert(Repo repo) {
                ImmutableSqlClientWrapper wrapper = ImmutableSqlClientWrapper.builder().repo(repo).client(client).names(ctx.toRepo(repo)).build();
                return new ClientInsertBuilderSqlPool(wrapper.getClient(), DocDBFactorySql.sqlMapper(wrapper.getNames()), DocDBFactorySql.sqlBuilder(wrapper.getNames()), handler);
            }

            @Override
            public Uni<ClientQuery> query(String repoNameOrId) {
                return this.repos().getByNameOrId(repoNameOrId).onItem().transform(repo -> this.query((Repo)repo));
            }

            @Override
            public ClientQuery query(Repo repo) {
                ImmutableSqlClientWrapper wrapper = ImmutableSqlClientWrapper.builder().repo(repo).client(client).names(ctx.toRepo(repo)).build();
                return new ClientQuerySqlPool(wrapper, DocDBFactorySql.sqlMapper(wrapper.getNames()), DocDBFactorySql.sqlBuilder(wrapper.getNames()), handler);
            }

            @Override
            public ClientState.ClientRepoState withRepo(Repo repo) {
                final ImmutableSqlClientWrapper wrapper = ImmutableSqlClientWrapper.builder().repo(repo).client(client).names(ctx.toRepo(repo)).build();
                return new ClientState.ClientRepoState(){

                    @Override
                    public ClientQuery query() {
                        return new ClientQuerySqlPool(wrapper, DocDBFactorySql.sqlMapper(wrapper.getNames()), DocDBFactorySql.sqlBuilder(wrapper.getNames()), handler);
                    }

                    @Override
                    public ClientInsertBuilder insert() {
                        return new ClientInsertBuilderSqlPool(wrapper.getClient(), DocDBFactorySql.sqlMapper(wrapper.getNames()), DocDBFactorySql.sqlBuilder(wrapper.getNames()), handler);
                    }
                };
            }

            @Override
            public Uni<ClientState.ClientRepoState> withRepo(String repoNameOrId) {
                return this.repos().getByNameOrId(repoNameOrId).onItem().transform(repo -> this.withRepo((Repo)repo));
            }
        };
    }

    public static SqlBuilder sqlBuilder(ClientCollections ctx) {
        return new DefaultSqlBuilder(ctx);
    }

    public static SqlMapper sqlMapper(ClientCollections ctx) {
        return new DefaultSqlMapper(ctx);
    }

    public static class Builder {
        private Pool client;
        private String db = "docdb";
        private ErrorHandler errorHandler;

        public Builder errorHandler(ErrorHandler errorHandler) {
            this.errorHandler = errorHandler;
            return this;
        }

        public Builder db(String db) {
            this.db = db;
            return this;
        }

        public Builder client(Pool client) {
            this.client = client;
            return this;
        }

        public DocDB build() {
            RepoAssert.notNull(this.client, () -> "client must be defined!");
            RepoAssert.notNull(this.db, () -> "db must be defined!");
            RepoAssert.notNull(this.errorHandler, () -> "errorHandler must be defined!");
            ClientCollections ctx = ClientCollections.defaults(this.db);
            return new DocDBDefault(DocDBFactorySql.state(ctx, this.client, this.errorHandler));
        }
    }
}

