/*
 * Decompiled with CFR 0.152.
 */
package io.resys.thena.docdb.sql.builders;

import io.resys.thena.docdb.api.models.Objects;
import io.resys.thena.docdb.spi.ClientQuery;
import io.resys.thena.docdb.spi.ErrorHandler;
import io.resys.thena.docdb.sql.SqlBuilder;
import io.resys.thena.docdb.sql.SqlMapper;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import io.vertx.mutiny.sqlclient.Pool;
import io.vertx.mutiny.sqlclient.Row;
import io.vertx.mutiny.sqlclient.RowIterator;
import java.util.ArrayList;
import java.util.List;

public class BlobQuerySqlPool
implements ClientQuery.BlobQuery {
    private final Pool client;
    private final SqlMapper sqlMapper;
    private final SqlBuilder sqlBuilder;
    private final ErrorHandler errorHandler;

    @Override
    public Uni<Objects.Blob> id(String blobId) {
        SqlBuilder.SqlTuple sql = this.sqlBuilder.blobs().getById(blobId);
        return this.client.preparedQuery(sql.getValue()).mapping(row -> this.sqlMapper.blob((Row)row)).execute(sql.getProps()).onItem().transform(rowset -> {
            RowIterator it = rowset.iterator();
            if (it.hasNext()) {
                return (Objects.Blob)it.next();
            }
            return null;
        }).onFailure(e -> this.errorHandler.notFound((Throwable)e)).recoverWithNull().onFailure().invoke(e -> this.errorHandler.deadEnd("Can't find 'BLOB' by 'id': '" + blobId + "'!", (Throwable)e));
    }

    @Override
    public Uni<List<Objects.Blob>> id(List<String> blobId) {
        SqlBuilder.SqlTuple sql = this.sqlBuilder.blobs().findByIds(blobId);
        return this.client.preparedQuery(sql.getValue()).mapping(row -> this.sqlMapper.blob((Row)row)).execute(sql.getProps()).onItem().transform(rowset -> {
            ArrayList<Objects.Blob> result = new ArrayList<Objects.Blob>();
            for (Objects.Blob item : rowset) {
                result.add(item);
            }
            return result;
        }).onFailure(e -> this.errorHandler.notFound((Throwable)e)).recoverWithNull().onFailure().invoke(e -> this.errorHandler.deadEnd("Can't find 'BLOB' by 'id'-s: '" + String.join((CharSequence)",", blobId) + "'!", (Throwable)e));
    }

    @Override
    public Multi<Objects.Blob> find() {
        SqlBuilder.Sql sql = this.sqlBuilder.blobs().findAll();
        return this.client.preparedQuery(sql.getValue()).mapping(row -> this.sqlMapper.blob((Row)row)).execute().onItem().transformToMulti(rowset -> Multi.createFrom().iterable((Iterable)rowset)).onFailure().invoke(e -> this.errorHandler.deadEnd("Can't find 'BLOB'!", (Throwable)e));
    }

    @Override
    public Multi<Objects.Blob> find(Objects.Tree tree) {
        SqlBuilder.SqlTuple sql = this.sqlBuilder.blobs().findByTree(tree);
        return this.client.preparedQuery(sql.getValue()).mapping(row -> this.sqlMapper.blob((Row)row)).execute(sql.getProps()).onItem().transformToMulti(rowset -> Multi.createFrom().iterable((Iterable)rowset)).onFailure().invoke(e -> this.errorHandler.deadEnd("Can't find 'BLOB' by tree: " + tree.getId() + "!", (Throwable)e));
    }

    public BlobQuerySqlPool(Pool client, SqlMapper sqlMapper, SqlBuilder sqlBuilder, ErrorHandler errorHandler) {
        this.client = client;
        this.sqlMapper = sqlMapper;
        this.sqlBuilder = sqlBuilder;
        this.errorHandler = errorHandler;
    }
}

