/*
 * Decompiled with CFR 0.152.
 */
package io.resys.thena.docdb.sql.builders;

import io.resys.thena.docdb.api.models.ImmutableMessage;
import io.resys.thena.docdb.api.models.Message;
import io.resys.thena.docdb.api.models.Objects;
import io.resys.thena.docdb.spi.ClientInsertBuilder;
import io.resys.thena.docdb.spi.ErrorHandler;
import io.resys.thena.docdb.spi.ImmutableInsertResult;
import io.resys.thena.docdb.spi.ImmutableUpsertResult;
import io.resys.thena.docdb.spi.commits.CommitVisitor;
import io.resys.thena.docdb.spi.commits.ImmutableCommitOutput;
import io.resys.thena.docdb.sql.SqlBuilder;
import io.resys.thena.docdb.sql.SqlMapper;
import io.resys.thena.docdb.sql.support.Execute;
import io.smallrye.mutiny.Uni;
import io.vertx.mutiny.sqlclient.Pool;
import io.vertx.mutiny.sqlclient.Row;
import io.vertx.mutiny.sqlclient.RowIterator;
import io.vertx.mutiny.sqlclient.SqlClientHelper;

public class ClientInsertBuilderSqlPool
implements ClientInsertBuilder {
    private final Pool client;
    private final SqlMapper sqlMapper;
    private final SqlBuilder sqlBuilder;
    private final ErrorHandler errorHandler;

    @Override
    public Uni<ClientInsertBuilder.InsertResult> tag(Objects.Tag tag) {
        SqlBuilder.SqlTuple tagInsert = this.sqlBuilder.tags().insertOne(tag);
        return this.client.preparedQuery(tagInsert.getValue()).execute(tagInsert.getProps()).onItem().transform(inserted -> ImmutableInsertResult.builder().duplicate(false).build()).onFailure(e -> this.errorHandler.duplicate((Throwable)e)).recoverWithItem(e -> ImmutableInsertResult.builder().duplicate(true).build()).onFailure().invoke(e -> this.errorHandler.deadEnd("Can't insert into 'TAG': '" + tagInsert.getValue() + "'!", (Throwable)e));
    }

    @Override
    public Uni<ClientInsertBuilder.UpsertResult> blob(Objects.Blob blob) {
        SqlBuilder.SqlTuple blobsInsert = this.sqlBuilder.blobs().insertOne(blob);
        return this.client.preparedQuery(blobsInsert.getValue()).execute(blobsInsert.getProps()).onItem().transform(updateResult -> ImmutableUpsertResult.builder().id(blob.getId()).isModified(true).target(blob).status(ClientInsertBuilder.UpsertStatus.OK).message(ImmutableMessage.builder().text("Blob with id:" + " '" + blob.getId() + "'" + " has been saved.").build()).build()).onFailure(e -> this.errorHandler.duplicate((Throwable)e)).recoverWithItem(e -> ImmutableUpsertResult.builder().id(blob.getId()).isModified(false).target(blob).status(ClientInsertBuilder.UpsertStatus.OK).message(ImmutableMessage.builder().text("Blob with id:" + " '" + blob.getId() + "'" + " is already saved.").build()).build()).onFailure().invoke(e -> this.errorHandler.deadEnd("Can't insert into 'BLOB': '" + blobsInsert.getValue() + "'!", (Throwable)e));
    }

    @Override
    public Uni<ClientInsertBuilder.UpsertResult> ref(Objects.Ref ref, Objects.Commit commit) {
        SqlBuilder.SqlTuple findByName = this.sqlBuilder.refs().getByName(ref.getName());
        return this.client.preparedQuery(findByName.getValue()).mapping(r -> this.sqlMapper.ref((Row)r)).execute(findByName.getProps()).onItem().transformToUni(item -> {
            RowIterator exists = item.iterator();
            if (!exists.hasNext()) {
                return this.createRef(ref, commit);
            }
            return this.updateRef((Objects.Ref)exists.next(), commit);
        });
    }

    public Uni<ClientInsertBuilder.UpsertResult> updateRef(Objects.Ref ref, Objects.Commit commit) {
        SqlBuilder.SqlTuple refInsert = this.sqlBuilder.refs().updateOne(ref, commit);
        return this.client.preparedQuery(refInsert.getValue()).execute(refInsert.getProps()).onItem().transform(updateResult -> {
            if (updateResult.rowCount() == 1) {
                return ImmutableUpsertResult.builder().id(ref.getName()).isModified(true).status(ClientInsertBuilder.UpsertStatus.OK).target(ref).message(ImmutableMessage.builder().text("Ref with id:" + " '" + ref.getName() + "'" + " has been updated.").build()).build();
            }
            return ImmutableUpsertResult.builder().id(ref.getName()).isModified(false).status(ClientInsertBuilder.UpsertStatus.CONFLICT).target(ref).message(ImmutableMessage.builder().text("Ref with" + " id: '" + ref.getName() + "'," + " commit: '" + ref.getCommit() + "'" + " is behind of the head.").build()).build();
        });
    }

    private Uni<ClientInsertBuilder.UpsertResult> createRef(Objects.Ref ref, Objects.Commit commit) {
        SqlBuilder.SqlTuple refsInsert = this.sqlBuilder.refs().insertOne(ref);
        return this.client.preparedQuery(refsInsert.getValue()).execute(refsInsert.getProps()).onItem().transform(updateResult -> ImmutableUpsertResult.builder().id(ref.getName()).isModified(true).target(ref).status(ClientInsertBuilder.UpsertStatus.OK).message(ImmutableMessage.builder().text("Ref with id:" + " '" + ref.getName() + "'" + " has been created.").build()).build()).onFailure(e -> this.errorHandler.duplicate((Throwable)e)).recoverWithItem(e -> ImmutableUpsertResult.builder().id(ref.getName()).isModified(false).target(ref).status(ClientInsertBuilder.UpsertStatus.CONFLICT).message(ImmutableMessage.builder().text("Ref with id:" + " '" + ref.getName() + "'" + " is already created.").build()).build()).onFailure().invoke(e -> this.errorHandler.deadEnd("Can't insert into 'REF': '" + refsInsert.getValue() + "'!", (Throwable)e));
    }

    @Override
    public Uni<ClientInsertBuilder.UpsertResult> tree(Objects.Tree tree) {
        SqlBuilder.SqlTuple treeInsert = this.sqlBuilder.trees().insertOne(tree);
        SqlBuilder.SqlTupleList treeValueInsert = this.sqlBuilder.treeItems().insertAll(tree);
        return SqlClientHelper.inTransactionUni((Pool)this.client, tx -> tx.preparedQuery(treeInsert.getValue()).execute(treeInsert.getProps()).onItem().transformToUni(junk -> tx.preparedQuery(treeValueInsert.getValue()).executeBatch(treeValueInsert.getProps()))).onItem().transform(updateResult -> ImmutableUpsertResult.builder().id(tree.getId()).isModified(true).target(tree).status(ClientInsertBuilder.UpsertStatus.OK).message(ImmutableMessage.builder().text("Tree with id:" + " '" + tree.getId() + "'" + " has been saved.").build()).build()).onFailure(e -> this.errorHandler.duplicate((Throwable)e)).recoverWithItem(e -> ImmutableUpsertResult.builder().id(tree.getId()).isModified(false).target(tree).status(ClientInsertBuilder.UpsertStatus.OK).message(ImmutableMessage.builder().text("Tree with id:" + " '" + tree.getId() + "'" + " is already saved.").build()).build()).onFailure().invoke(e -> this.errorHandler.deadEnd("Can't insert into \r\n'TREE': " + treeInsert.getValue() + "\r\n  and/or\r\n 'TREE_VALUE' : '" + treeValueInsert.getValue() + "'!", (Throwable)e));
    }

    @Override
    public Uni<ClientInsertBuilder.UpsertResult> commit(Objects.Commit commit) {
        SqlBuilder.SqlTuple commitsInsert = this.sqlBuilder.commits().insertOne(commit);
        return this.client.preparedQuery(commitsInsert.getValue()).execute(commitsInsert.getProps()).onItem().transform(updateResult -> ImmutableUpsertResult.builder().id(commit.getId()).isModified(true).target(commit).status(ClientInsertBuilder.UpsertStatus.OK).message(ImmutableMessage.builder().text("Commit with id:" + " '" + commit.getId() + "'" + " has been saved.").build()).build()).onFailure(e -> this.errorHandler.duplicate((Throwable)e)).recoverWithItem(e -> ImmutableUpsertResult.builder().id(commit.getId()).isModified(false).target(commit).status(ClientInsertBuilder.UpsertStatus.CONFLICT).message(ImmutableMessage.builder().text("Commit with id:" + " '" + commit.getId() + "'" + " is already saved.").build()).build()).onFailure().invoke(e -> this.errorHandler.deadEnd("Can't insert into 'COMMIT': '" + commitsInsert.getValue() + "'!", (Throwable)e));
    }

    @Override
    public Uni<CommitVisitor.CommitOutput> output(CommitVisitor.CommitOutput output) {
        SqlBuilder.SqlTupleList blobsInsert = this.sqlBuilder.blobs().insertAll(output.getBlobs());
        SqlBuilder.SqlTuple treeInsert = this.sqlBuilder.trees().insertOne(output.getTree());
        SqlBuilder.SqlTupleList treeValueInsert = this.sqlBuilder.treeItems().insertAll(output.getTree());
        SqlBuilder.SqlTuple commitsInsert = this.sqlBuilder.commits().insertOne(output.getCommit());
        SqlBuilder.SqlTuple findRefByName = this.sqlBuilder.refs().getByName(output.getRef().getName());
        return SqlClientHelper.inTransactionUni((Pool)this.client, tx -> {
            Uni start = blobsInsert.getProps().isEmpty() ? Uni.createFrom().item((Object)this.successOutput(output, "No new blobs provided, nothing to save")) : Execute.apply(tx, blobsInsert).onItem().transform(row -> this.successOutput(output, "Blobs saved, number of new entries: " + row.rowCount())).onFailure().recoverWithItem(e -> this.failOutput(output, "Failed to create blobs", (Throwable)e));
            return start.chain(next -> {
                if (next.getStatus() == CommitVisitor.CommitOutputStatus.OK) {
                    return Execute.apply(tx, treeInsert).onItem().transform(row -> this.successOutput((CommitVisitor.CommitOutput)next, "Tree saved, number of new entries: " + row.rowCount())).onFailure().recoverWithItem(e -> this.failOutput((CommitVisitor.CommitOutput)next, "Failed to create tree \r\n" + output.getTree(), (Throwable)e));
                }
                return Uni.createFrom().item(next);
            }).chain(next -> {
                if (next.getStatus() == CommitVisitor.CommitOutputStatus.OK) {
                    if (treeValueInsert.getProps().isEmpty()) {
                        return Uni.createFrom().item((Object)this.successOutput((CommitVisitor.CommitOutput)next, "Tree Values saved, number of new entries: 0"));
                    }
                    return Execute.apply(tx, treeValueInsert).onItem().transform(row -> this.successOutput((CommitVisitor.CommitOutput)next, "Tree Values saved, number of new entries: " + row.rowCount())).onFailure().recoverWithItem(e -> this.failOutput((CommitVisitor.CommitOutput)next, "Failed to create tree values", (Throwable)e));
                }
                return Uni.createFrom().item(next);
            }).chain(next -> {
                if (next.getStatus() == CommitVisitor.CommitOutputStatus.OK) {
                    return Execute.apply(tx, commitsInsert).onItem().transform(row -> this.successOutput((CommitVisitor.CommitOutput)next, "Commit saved, number of new entries: " + row.rowCount())).onFailure().recoverWithItem(e -> this.failOutput((CommitVisitor.CommitOutput)next, "Failed to create commit", (Throwable)e));
                }
                return Uni.createFrom().item(next);
            }).chain(next -> {
                if (next.getStatus() == CommitVisitor.CommitOutputStatus.OK) {
                    return Execute.apply(tx, findRefByName).onItem().transformToUni(item -> {
                        RowIterator exists = item.iterator();
                        if (!exists.hasNext()) {
                            return Execute.apply(tx, this.sqlBuilder.refs().insertOne(next.getRef())).onItem().transform(row -> this.successOutput((CommitVisitor.CommitOutput)next, "New ref created: " + next.getRef().getName() + ": " + next.getRef().getCommit()));
                        }
                        return Execute.apply(tx, this.sqlBuilder.refs().updateOne(next.getRef(), next.getCommit())).onItem().transform(row -> this.successOutput((CommitVisitor.CommitOutput)next, "Existing ref: " + next.getRef().getName() + ", updated with commit: " + next.getRef().getCommit()));
                    }).onFailure().recoverWithItem(e -> this.failOutput(output, "Failed to create/update ref", (Throwable)e));
                }
                return Uni.createFrom().item(next);
            });
        });
    }

    private CommitVisitor.CommitOutput successOutput(CommitVisitor.CommitOutput current, String msg) {
        return ImmutableCommitOutput.builder().from(current).status(CommitVisitor.CommitOutputStatus.OK).addMessages((Message)ImmutableMessage.builder().text(msg).build()).build();
    }

    private CommitVisitor.CommitOutput failOutput(CommitVisitor.CommitOutput current, String msg, Throwable t) {
        return ImmutableCommitOutput.builder().from(current).status(CommitVisitor.CommitOutputStatus.ERROR).addMessages((Message)ImmutableMessage.builder().text(msg).build()).build();
    }

    public ClientInsertBuilderSqlPool(Pool client, SqlMapper sqlMapper, SqlBuilder sqlBuilder, ErrorHandler errorHandler) {
        this.client = client;
        this.sqlMapper = sqlMapper;
        this.sqlBuilder = sqlBuilder;
        this.errorHandler = errorHandler;
    }
}

