/*
 * Decompiled with CFR 0.152.
 */
package io.resys.thena.docdb.sql.builders;

import io.resys.thena.docdb.api.models.Objects;
import io.resys.thena.docdb.spi.ClientQuery;
import io.resys.thena.docdb.spi.ErrorHandler;
import io.resys.thena.docdb.spi.support.RepoAssert;
import io.resys.thena.docdb.sql.SqlBuilder;
import io.resys.thena.docdb.sql.SqlMapper;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import io.vertx.mutiny.sqlclient.Pool;
import io.vertx.mutiny.sqlclient.Row;
import io.vertx.mutiny.sqlclient.RowIterator;

public class RefQuerySqlPool
implements ClientQuery.RefQuery {
    private final Pool client;
    private final SqlMapper sqlMapper;
    private final SqlBuilder sqlBuilder;
    private final ErrorHandler errorHandler;

    @Override
    public Uni<Objects.Ref> nameOrCommit(String refNameOrCommit) {
        RepoAssert.notEmpty(refNameOrCommit, () -> "refNameOrCommit must be defined!");
        SqlBuilder.SqlTuple sql = this.sqlBuilder.refs().getByNameOrCommit(refNameOrCommit);
        return this.client.preparedQuery(sql.getValue()).mapping(row -> this.sqlMapper.ref((Row)row)).execute(sql.getProps()).onItem().transform(rowset -> {
            RowIterator it = rowset.iterator();
            if (it.hasNext()) {
                return (Objects.Ref)it.next();
            }
            return null;
        }).onFailure().invoke(e -> this.errorHandler.deadEnd("Can't find 'REF' by refNameOrCommit: '" + refNameOrCommit + "'!", (Throwable)e));
    }

    @Override
    public Uni<Objects.Ref> get() {
        SqlBuilder.Sql sql = this.sqlBuilder.refs().getFirst();
        return this.client.preparedQuery(sql.getValue()).mapping(row -> this.sqlMapper.ref((Row)row)).execute().onItem().transform(rowset -> {
            RowIterator it = rowset.iterator();
            if (it.hasNext()) {
                return (Objects.Ref)it.next();
            }
            return null;
        }).onFailure().invoke(e -> this.errorHandler.deadEnd("Can't find 'REF'!", (Throwable)e));
    }

    @Override
    public Multi<Objects.Ref> find() {
        SqlBuilder.Sql sql = this.sqlBuilder.refs().findAll();
        return this.client.preparedQuery(sql.getValue()).mapping(row -> this.sqlMapper.ref((Row)row)).execute().onItem().transformToMulti(rowset -> Multi.createFrom().iterable((Iterable)rowset)).onFailure().invoke(e -> this.errorHandler.deadEnd("Can't find 'REF'!", (Throwable)e));
    }

    @Override
    public Uni<Objects.Ref> name(String name) {
        RepoAssert.notEmpty(name, () -> "name must be defined!");
        SqlBuilder.SqlTuple sql = this.sqlBuilder.refs().getByName(name);
        return this.client.preparedQuery(sql.getValue()).mapping(row -> this.sqlMapper.ref((Row)row)).execute(sql.getProps()).onItem().transform(rowset -> {
            RowIterator it = rowset.iterator();
            if (it.hasNext()) {
                return (Objects.Ref)it.next();
            }
            return null;
        }).onFailure().invoke(e -> this.errorHandler.deadEnd("Can't find 'REF' by name: '" + name + "'!", (Throwable)e));
    }

    public RefQuerySqlPool(Pool client, SqlMapper sqlMapper, SqlBuilder sqlBuilder, ErrorHandler errorHandler) {
        this.client = client;
        this.sqlMapper = sqlMapper;
        this.sqlBuilder = sqlBuilder;
        this.errorHandler = errorHandler;
    }
}

