/*
 * Decompiled with CFR 0.152.
 */
package io.resys.thena.docdb.sql.builders;

import io.resys.thena.docdb.api.models.Repo;
import io.resys.thena.docdb.spi.ClientCollections;
import io.resys.thena.docdb.spi.ClientState;
import io.resys.thena.docdb.spi.ErrorHandler;
import io.resys.thena.docdb.sql.SqlBuilder;
import io.resys.thena.docdb.sql.SqlMapper;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import io.vertx.mutiny.sqlclient.Pool;
import io.vertx.mutiny.sqlclient.Row;
import io.vertx.mutiny.sqlclient.RowIterator;
import io.vertx.mutiny.sqlclient.SqlClientHelper;

public class RepoBuilderSqlPool
implements ClientState.RepoBuilder {
    private final Pool client;
    private final ClientCollections names;
    private final SqlMapper sqlMapper;
    private final SqlBuilder sqlBuilder;
    private final ErrorHandler errorHandler;

    @Override
    public Uni<Repo> getByName(String name) {
        SqlBuilder.SqlTuple sql = this.sqlBuilder.repo().getByName(name);
        return this.client.preparedQuery(sql.getValue()).mapping(row -> this.sqlMapper.repo((Row)row)).execute(sql.getProps()).onItem().transform(rowset -> {
            RowIterator it = rowset.iterator();
            if (it.hasNext()) {
                return (Repo)it.next();
            }
            return null;
        }).onFailure(e -> this.errorHandler.notFound((Throwable)e)).recoverWithNull().onFailure().invoke(e -> this.errorHandler.deadEnd("Can't find 'REPOS' by 'name'!", (Throwable)e));
    }

    @Override
    public Uni<Repo> getByNameOrId(String nameOrId) {
        SqlBuilder.SqlTuple sql = this.sqlBuilder.repo().getByNameOrId(nameOrId);
        return this.client.preparedQuery(sql.getValue()).mapping(row -> this.sqlMapper.repo((Row)row)).execute(sql.getProps()).onItem().transform(rowset -> {
            RowIterator it = rowset.iterator();
            if (it.hasNext()) {
                return (Repo)it.next();
            }
            return null;
        }).onFailure(e -> this.errorHandler.notFound((Throwable)e)).recoverWithNull().onFailure().invoke(e -> this.errorHandler.deadEnd("Can't find 'REPOS' by 'name' or 'id'!", (Throwable)e));
    }

    @Override
    public Uni<Repo> insert(Repo newRepo) {
        ClientCollections next = this.names.toRepo(newRepo);
        SqlBuilder sqlBuilder = this.sqlBuilder.withOptions(next);
        return SqlClientHelper.inTransactionUni((Pool)this.client, tx -> {
            SqlBuilder.SqlTuple repoInsert = sqlBuilder.repo().insertOne(newRepo);
            String tablesCreate = sqlBuilder.blobs().create().getValue() + sqlBuilder.commits().create().getValue() + sqlBuilder.treeItems().create().getValue() + sqlBuilder.trees().create().getValue() + sqlBuilder.refs().create().getValue() + sqlBuilder.tags().create().getValue() + sqlBuilder.commits().constraints().getValue() + sqlBuilder.refs().constraints().getValue() + sqlBuilder.tags().constraints().getValue() + sqlBuilder.treeItems().constraints().getValue();
            Uni create = this.client.preparedQuery(sqlBuilder.repo().create().getValue()).execute().onItem().transformToUni(data -> Uni.createFrom().voidItem()).onFailure().invoke(e -> this.errorHandler.deadEnd("Can't create table 'REPOS'!", (Throwable)e));
            Uni insert = tx.preparedQuery(repoInsert.getValue()).execute(repoInsert.getProps()).onItem().transformToUni(rowSet -> Uni.createFrom().voidItem()).onFailure().invoke(e -> this.errorHandler.deadEnd("Can't insert into 'REPO': '" + repoInsert.getValue() + "'!", (Throwable)e));
            Uni nested = tx.query(tablesCreate).execute().onItem().transformToUni(rowSet -> Uni.createFrom().voidItem()).onFailure().invoke(e -> this.errorHandler.deadEnd("Can't create tables: " + tablesCreate, (Throwable)e));
            return create.onItem().transformToUni(junk -> insert).onItem().transformToUni(junk -> nested).onItem().transform(junk -> newRepo);
        });
    }

    @Override
    public Multi<Repo> find() {
        return this.client.preparedQuery(this.sqlBuilder.repo().findAll().getValue()).mapping(row -> this.sqlMapper.repo((Row)row)).execute().onItem().transformToMulti(rowset -> Multi.createFrom().iterable((Iterable)rowset)).onFailure(e -> this.errorHandler.notFound((Throwable)e)).recoverWithCompletion().onFailure().invoke(e -> this.errorHandler.deadEnd("Can't find 'REPOS'!", (Throwable)e));
    }

    @Override
    public Uni<Void> create() {
        return this.client.preparedQuery(this.sqlBuilder.repo().create().getValue()).execute().onItem().transformToUni(data -> Uni.createFrom().voidItem()).onFailure().invoke(e -> this.errorHandler.deadEnd("Can't create table 'REPOS'!", (Throwable)e));
    }

    public RepoBuilderSqlPool(Pool client, ClientCollections names, SqlMapper sqlMapper, SqlBuilder sqlBuilder, ErrorHandler errorHandler) {
        this.client = client;
        this.names = names;
        this.sqlMapper = sqlMapper;
        this.sqlBuilder = sqlBuilder;
        this.errorHandler = errorHandler;
    }
}

