/*
 * Decompiled with CFR 0.152.
 */
package io.resys.thena.docdb.sql.defaults;

import io.resys.thena.docdb.api.models.Objects;
import io.resys.thena.docdb.spi.ClientCollections;
import io.resys.thena.docdb.sql.ImmutableSql;
import io.resys.thena.docdb.sql.ImmutableSqlTuple;
import io.resys.thena.docdb.sql.SqlBuilder;
import io.resys.thena.docdb.sql.defaults.SqlStatement;
import io.vertx.mutiny.sqlclient.Tuple;
import java.util.Arrays;

public class DefaultCommitSqlBuilder
implements SqlBuilder.CommitSqlBuilder {
    private final ClientCollections options;

    public DefaultCommitSqlBuilder(ClientCollections options) {
        this.options = options;
    }

    @Override
    public SqlBuilder.Sql create() {
        return ImmutableSql.builder().value(new SqlStatement().ln().append("CREATE TABLE ").append(this.options.getCommits()).ln().append("(").ln().append("  id VARCHAR(40) PRIMARY KEY,").ln().append("  datetime VARCHAR(29) NOT NULL,").ln().append("  author VARCHAR(40) NOT NULL,").ln().append("  message VARCHAR(255) NOT NULL,").ln().append("  tree VARCHAR(40) NOT NULL,").ln().append("  parent VARCHAR(40),").ln().append("  merge VARCHAR(40)").ln().append(");").ln().build()).build();
    }

    @Override
    public SqlBuilder.Sql constraints() {
        return ImmutableSql.builder().value(new SqlStatement().ln().append("ALTER TABLE ").append(this.options.getCommits()).ln().append("  ADD CONSTRAINT ").append(this.options.getCommits()).append("_COMMIT_PARENT_FK").ln().append("  FOREIGN KEY (parent)").ln().append("  REFERENCES ").append(this.options.getCommits()).append(" (id);").ln().append("ALTER TABLE ").append(this.options.getCommits()).ln().append("  ADD CONSTRAINT ").append(this.options.getCommits()).append("_COMMIT_TREE_FK").ln().append("  FOREIGN KEY (tree)").ln().append("  REFERENCES ").append(this.options.getTrees()).append(" (id);").ln().build()).build();
    }

    @Override
    public SqlBuilder.Sql findAll() {
        return ImmutableSql.builder().value(new SqlStatement().append("SELECT * FROM ").append(this.options.getCommits()).build()).build();
    }

    @Override
    public SqlBuilder.SqlTuple getById(String id) {
        return ImmutableSqlTuple.builder().value(new SqlStatement().append("SELECT * FROM ").append(this.options.getCommits()).append(" WHERE id = $1").append(" FETCH FIRST ROW ONLY").build()).props(Tuple.of((Object)id)).build();
    }

    @Override
    public SqlBuilder.SqlTuple insertOne(Objects.Commit commit) {
        String message = commit.getMessage();
        if (commit.getMessage().length() > 100) {
            message = message.substring(0, 100);
        }
        return ImmutableSqlTuple.builder().value(new SqlStatement().append("INSERT INTO ").append(this.options.getCommits()).append(" (id, datetime, author, message, tree, parent, merge) VALUES($1, $2, $3, $4, $5, $6, $7)").build()).props(Tuple.from(Arrays.asList(commit.getId(), commit.getDateTime().toString(), commit.getAuthor(), message, commit.getTree(), commit.getParent().orElse(null), commit.getMerge().orElse(null)))).build();
    }
}

