/*
 * Decompiled with CFR 0.152.
 */
package io.resys.thena.docdb.sql.defaults;

import io.resys.thena.docdb.api.models.Objects;
import io.resys.thena.docdb.spi.ClientCollections;
import io.resys.thena.docdb.sql.ImmutableSql;
import io.resys.thena.docdb.sql.ImmutableSqlTuple;
import io.resys.thena.docdb.sql.SqlBuilder;
import io.resys.thena.docdb.sql.defaults.SqlStatement;
import io.vertx.mutiny.sqlclient.Tuple;

public class DefaultTagSqlBuilder
implements SqlBuilder.TagSqlBuilder {
    private final ClientCollections options;

    public DefaultTagSqlBuilder(ClientCollections options) {
        this.options = options;
    }

    @Override
    public SqlBuilder.Sql create() {
        return ImmutableSql.builder().value(new SqlStatement().ln().append("CREATE TABLE ").append(this.options.getTags()).ln().append("(").ln().append("  id VARCHAR(40) PRIMARY KEY,").ln().append("  commit VARCHAR(40) NOT NULL,").ln().append("  datetime VARCHAR(29) NOT NULL,").ln().append("  author VARCHAR(40) NOT NULL,").ln().append("  message VARCHAR(100) NOT NULL").ln().append(");").ln().build()).build();
    }

    @Override
    public SqlBuilder.Sql constraints() {
        return ImmutableSql.builder().value(new SqlStatement().ln().append("ALTER TABLE ").append(this.options.getTags()).ln().append("  ADD CONSTRAINT ").append(this.options.getTags()).append("_TAG_COMMIT_FK").ln().append("  FOREIGN KEY (commit)").ln().append("  REFERENCES ").append(this.options.getCommits()).append(" (id);").ln().build()).build();
    }

    @Override
    public SqlBuilder.Sql findAll() {
        return ImmutableSql.builder().value(new SqlStatement().append("SELECT * FROM ").append(this.options.getTags()).build()).build();
    }

    @Override
    public SqlBuilder.SqlTuple getByName(String name) {
        return ImmutableSqlTuple.builder().value(new SqlStatement().append("SELECT * FROM ").append(this.options.getTags()).append(" WHERE id = $1").append(" FETCH FIRST ROW ONLY").build()).props(Tuple.of((Object)name)).build();
    }

    @Override
    public SqlBuilder.SqlTuple deleteByName(String name) {
        return ImmutableSqlTuple.builder().value(new SqlStatement().append("DELETE FROM ").append(this.options.getTags()).append(" WHERE id = $1").build()).props(Tuple.of((Object)name)).build();
    }

    @Override
    public SqlBuilder.Sql getFirst() {
        return ImmutableSql.builder().value(new SqlStatement().append("SELECT * FROM ").append(this.options.getTags()).append(" FETCH FIRST ROW ONLY").build()).build();
    }

    @Override
    public SqlBuilder.SqlTuple insertOne(Objects.Tag newTag) {
        return ImmutableSqlTuple.builder().value(new SqlStatement().append("INSERT INTO ").append(this.options.getTags()).append(" (id, commit, datetime, author, message) VALUES($1, $2, $3, $4, $5)").build()).props(Tuple.of((Object)newTag.getName(), (Object)newTag.getCommit(), (Object)newTag.getDateTime().toString(), (Object)newTag.getAuthor(), (Object)newTag.getMessage())).build();
    }
}

