/*
 * Decompiled with CFR 0.152.
 */
package io.resys.thena.docdb.sql.support;

import io.resys.thena.docdb.sql.SqlBuilder;
import io.smallrye.mutiny.Uni;
import io.vertx.mutiny.sqlclient.Row;
import io.vertx.mutiny.sqlclient.RowSet;
import io.vertx.mutiny.sqlclient.SqlClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Execute {
    private static final Logger LOGGER = LoggerFactory.getLogger(Execute.class);

    public static Uni<RowSet<Row>> apply(SqlClient client, SqlBuilder.Sql sql) {
        return client.preparedQuery(sql.getValue()).execute().onFailure().invoke(e -> LOGGER.error(System.lineSeparator() + "Failed to execute command." + System.lineSeparator() + "  sql: " + sql.getValue() + System.lineSeparator() + "  error:" + e.getMessage(), e));
    }

    public static Uni<RowSet<Row>> apply(SqlClient client, SqlBuilder.SqlTuple sql) {
        return client.preparedQuery(sql.getValue()).execute(sql.getProps()).onFailure().invoke(e -> LOGGER.error(System.lineSeparator() + "Failed to execute single command." + System.lineSeparator() + "  sql: " + sql.getValue() + System.lineSeparator() + "  error:" + e.getMessage(), e));
    }

    public static Uni<RowSet<Row>> apply(SqlClient client, SqlBuilder.SqlTupleList sql) {
        return client.preparedQuery(sql.getValue()).executeBatch(sql.getProps()).onFailure().invoke(e -> LOGGER.error(System.lineSeparator() + "Failed to execute batch command." + System.lineSeparator() + "  sql: " + sql.getValue() + System.lineSeparator() + "  error:" + e.getMessage(), e));
    }
}

