/*
 * Decompiled with CFR 0.152.
 */
package io.resys.thena.docdb.sql.support;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.resys.thena.docdb.api.models.Repo;
import io.resys.thena.docdb.spi.ClientCollections;
import io.resys.thena.docdb.sql.support.SqlClientWrapper;
import io.vertx.mutiny.sqlclient.Pool;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="SqlClientWrapper", generator="Immutables")
@Immutable
public final class ImmutableSqlClientWrapper
implements SqlClientWrapper {
    private final Repo repo;
    private final Pool client;
    private final ClientCollections names;

    private ImmutableSqlClientWrapper(Repo repo, Pool client, ClientCollections names) {
        this.repo = repo;
        this.client = client;
        this.names = names;
    }

    @Override
    public Repo getRepo() {
        return this.repo;
    }

    @Override
    public Pool getClient() {
        return this.client;
    }

    @Override
    public ClientCollections getNames() {
        return this.names;
    }

    public final ImmutableSqlClientWrapper withRepo(Repo value) {
        if (this.repo == value) {
            return this;
        }
        Repo newValue = Objects.requireNonNull(value, "repo");
        return new ImmutableSqlClientWrapper(newValue, this.client, this.names);
    }

    public final ImmutableSqlClientWrapper withClient(Pool value) {
        if (this.client == value) {
            return this;
        }
        Pool newValue = Objects.requireNonNull(value, "client");
        return new ImmutableSqlClientWrapper(this.repo, newValue, this.names);
    }

    public final ImmutableSqlClientWrapper withNames(ClientCollections value) {
        if (this.names == value) {
            return this;
        }
        ClientCollections newValue = Objects.requireNonNull(value, "names");
        return new ImmutableSqlClientWrapper(this.repo, this.client, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableSqlClientWrapper && this.equalTo((ImmutableSqlClientWrapper)another);
    }

    private boolean equalTo(ImmutableSqlClientWrapper another) {
        return this.repo.equals(another.repo) && this.client.equals((Object)another.client) && this.names.equals(another.names);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.repo.hashCode();
        h += (h << 5) + this.client.hashCode();
        h += (h << 5) + this.names.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"SqlClientWrapper").omitNullValues().add("repo", (Object)this.repo).add("client", (Object)this.client).add("names", (Object)this.names).toString();
    }

    public static ImmutableSqlClientWrapper copyOf(SqlClientWrapper instance) {
        if (instance instanceof ImmutableSqlClientWrapper) {
            return (ImmutableSqlClientWrapper)instance;
        }
        return ImmutableSqlClientWrapper.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="SqlClientWrapper", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_REPO = 1L;
        private static final long INIT_BIT_CLIENT = 2L;
        private static final long INIT_BIT_NAMES = 4L;
        private long initBits = 7L;
        @Nullable
        private Repo repo;
        @Nullable
        private Pool client;
        @Nullable
        private ClientCollections names;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(SqlClientWrapper instance) {
            Objects.requireNonNull(instance, "instance");
            this.repo(instance.getRepo());
            this.client(instance.getClient());
            this.names(instance.getNames());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder repo(Repo repo) {
            this.repo = Objects.requireNonNull(repo, "repo");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder client(Pool client) {
            this.client = Objects.requireNonNull(client, "client");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder names(ClientCollections names) {
            this.names = Objects.requireNonNull(names, "names");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public ImmutableSqlClientWrapper build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableSqlClientWrapper(this.repo, this.client, this.names);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("repo");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("client");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("names");
            }
            return "Cannot build SqlClientWrapper, some of required attributes are not set " + attributes;
        }
    }
}

