/*
 * Decompiled with CFR 0.152.
 */
package io.roastedroot.zerofs;

import java.io.IOException;
import java.nio.file.ClosedWatchServiceException;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.nio.file.Watchable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;

abstract class AbstractWatchService
implements WatchService {
    private final BlockingQueue<WatchKey> queue = new LinkedBlockingQueue<WatchKey>();
    private final WatchKey poison = new Key(this, null, Set.of());
    private final AtomicBoolean open = new AtomicBoolean(true);

    AbstractWatchService() {
    }

    public Key register(Watchable watchable, Iterable<? extends WatchEvent.Kind<?>> eventTypes) throws IOException {
        this.checkOpen();
        return new Key(this, watchable, eventTypes);
    }

    public boolean isOpen() {
        return this.open.get();
    }

    final void enqueue(Key key) {
        if (this.isOpen()) {
            this.queue.add(key);
        }
    }

    public void cancelled(Key key) {
    }

    List<WatchKey> queuedKeys() {
        return List.copyOf(this.queue);
    }

    @Override
    public WatchKey poll() {
        this.checkOpen();
        return this.check((WatchKey)this.queue.poll());
    }

    @Override
    public WatchKey poll(long timeout, TimeUnit unit) throws InterruptedException {
        this.checkOpen();
        return this.check(this.queue.poll(timeout, unit));
    }

    @Override
    public WatchKey take() throws InterruptedException {
        this.checkOpen();
        return this.check(this.queue.take());
    }

    private WatchKey check(WatchKey key) {
        if (key == this.poison) {
            this.queue.offer(this.poison);
            throw new ClosedWatchServiceException();
        }
        return key;
    }

    protected final void checkOpen() {
        if (!this.open.get()) {
            throw new ClosedWatchServiceException();
        }
    }

    @Override
    public void close() {
        if (this.open.compareAndSet(true, false)) {
            this.queue.clear();
            this.queue.offer(this.poison);
        }
    }

    static final class Key
    implements WatchKey {
        static final int MAX_QUEUE_SIZE = 256;
        private final AbstractWatchService watcher;
        private final Watchable watchable;
        private final Set<WatchEvent.Kind<?>> subscribedTypes;
        private final AtomicReference<State> state = new AtomicReference<State>(State.READY);
        private final AtomicBoolean valid = new AtomicBoolean(true);
        private final AtomicInteger overflow = new AtomicInteger();
        private final BlockingQueue<WatchEvent<?>> events = new ArrayBlockingQueue(256);

        private static WatchEvent<Object> overflowEvent(int count) {
            return new Event<Object>(StandardWatchEventKinds.OVERFLOW, count, null);
        }

        public Key(AbstractWatchService watcher, Watchable watchable, Iterable<? extends WatchEvent.Kind<?>> subscribedTypes) {
            this.watcher = Objects.requireNonNull(watcher);
            this.watchable = watchable;
            this.subscribedTypes = new HashSet();
            subscribedTypes.forEach(this.subscribedTypes::add);
        }

        State state() {
            return this.state.get();
        }

        public boolean subscribesTo(WatchEvent.Kind<?> eventType) {
            return this.subscribedTypes.contains(eventType);
        }

        public void post(WatchEvent<?> event) {
            if (!this.events.offer(event)) {
                this.overflow.incrementAndGet();
            }
        }

        public void signal() {
            if (this.state.getAndSet(State.SIGNALLED) == State.READY) {
                this.watcher.enqueue(this);
            }
        }

        @Override
        public boolean isValid() {
            return this.watcher.isOpen() && this.valid.get();
        }

        @Override
        public List<WatchEvent<?>> pollEvents() {
            ArrayList<WatchEvent<Object>> result = new ArrayList<WatchEvent<Object>>(this.events.size());
            this.events.drainTo(result);
            int overflowCount = this.overflow.getAndSet(0);
            if (overflowCount != 0) {
                result.add(Key.overflowEvent(overflowCount));
            }
            return Collections.unmodifiableList(result);
        }

        @Override
        public boolean reset() {
            if (this.isValid() && this.state.compareAndSet(State.SIGNALLED, State.READY) && !this.events.isEmpty()) {
                this.signal();
            }
            return this.isValid();
        }

        @Override
        public void cancel() {
            this.valid.set(false);
            this.watcher.cancelled(this);
        }

        @Override
        public Watchable watchable() {
            return this.watchable;
        }

        static enum State {
            READY,
            SIGNALLED;

        }
    }

    static final class Event<T>
    implements WatchEvent<T> {
        private final WatchEvent.Kind<T> kind;
        private final int count;
        private final T context;

        public Event(WatchEvent.Kind<T> kind, int count, T context) {
            this.kind = Objects.requireNonNull(kind);
            if (count < 0) {
                throw new IllegalArgumentException(String.format("count (%s) must be non-negative", count));
            }
            this.count = count;
            this.context = context;
        }

        @Override
        public WatchEvent.Kind<T> kind() {
            return this.kind;
        }

        @Override
        public int count() {
            return this.count;
        }

        @Override
        public T context() {
            return this.context;
        }

        public boolean equals(Object obj) {
            if (obj instanceof Event) {
                Event other = (Event)obj;
                return this.kind().equals(other.kind()) && this.count() == other.count() && Objects.equals(this.context(), other.context());
            }
            return false;
        }

        public int hashCode() {
            return Objects.hash(this.kind(), this.count(), this.context());
        }

        public String toString() {
            return "Event{kind=" + String.valueOf(this.kind) + ", count=" + this.count + ", context=" + String.valueOf(this.context) + "}";
        }
    }
}

