/*
 * Decompiled with CFR 0.152.
 */
package io.roastedroot.zerofs;

import io.roastedroot.zerofs.File;
import io.roastedroot.zerofs.FileLookup;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttributeView;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public abstract class AttributeProvider {
    public abstract String name();

    public Set<String> inherits() {
        return Set.of();
    }

    public abstract Class<? extends FileAttributeView> viewType();

    public abstract FileAttributeView view(FileLookup var1, Map<String, FileAttributeView> var2);

    public Map<String, ?> defaultValues(Map<String, ?> userDefaults) {
        return Map.of();
    }

    public abstract Set<String> fixedAttributes();

    public boolean supports(String attribute) {
        return this.fixedAttributes().contains(attribute);
    }

    public Set<String> attributes(File file) {
        return this.fixedAttributes();
    }

    public abstract Object get(File var1, String var2);

    public abstract void set(File var1, String var2, String var3, Object var4, boolean var5);

    public Class<? extends BasicFileAttributes> attributesType() {
        return null;
    }

    public BasicFileAttributes readAttributes(File file) {
        throw new UnsupportedOperationException();
    }

    protected static RuntimeException unsettable(String view, String attribute, boolean create) {
        AttributeProvider.checkNotCreate(view, attribute, create);
        throw new IllegalArgumentException("cannot set attribute '" + view + ":" + attribute + "'");
    }

    protected static void checkNotCreate(String view, String attribute, boolean create) {
        if (create) {
            throw new UnsupportedOperationException("cannot set attribute '" + view + ":" + attribute + "' during file creation");
        }
    }

    protected static <T> T checkType(String view, String attribute, Object value, Class<T> type) {
        Objects.requireNonNull(value);
        if (type.isInstance(value)) {
            return type.cast(value);
        }
        throw AttributeProvider.invalidType(view, attribute, value, type);
    }

    protected static IllegalArgumentException invalidType(String view, String attribute, Object value, Class<?> ... expectedTypes) {
        Object expected = expectedTypes.length == 1 ? expectedTypes[0] : "one of " + Arrays.toString(expectedTypes);
        throw new IllegalArgumentException("invalid type " + String.valueOf(value.getClass()) + " for attribute '" + view + ":" + attribute + "': expected " + String.valueOf(expected));
    }
}

