/*
 * Decompiled with CFR 0.152.
 */
package io.roastedroot.zerofs;

import io.roastedroot.zerofs.AttributeCopyOption;
import io.roastedroot.zerofs.AttributeProvider;
import io.roastedroot.zerofs.Configuration;
import io.roastedroot.zerofs.File;
import io.roastedroot.zerofs.FileLookup;
import io.roastedroot.zerofs.StandardAttributeProviders;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileAttributeView;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

final class AttributeService {
    private static final String ALL_ATTRIBUTES = "*";
    private final Map<String, AttributeProvider> providersByName;
    private final Map<Class<?>, AttributeProvider> providersByViewType;
    private final Map<Class<?>, AttributeProvider> providersByAttributesType;
    private final List<FileAttribute<?>> defaultValues;
    private static final String ATTRIBUTE_SPLITTER = ",";

    public AttributeService(Configuration configuration) {
        this(AttributeService.getProviders(configuration), configuration.defaultAttributeValues);
    }

    public AttributeService(Iterable<? extends AttributeProvider> providers, Map<String, ?> userProvidedDefaults) {
        HashMap<String, AttributeProvider> byViewNameBuilder = new HashMap<String, AttributeProvider>();
        HashMap<Class<? extends FileAttributeView>, AttributeProvider> byViewTypeBuilder = new HashMap<Class<? extends FileAttributeView>, AttributeProvider>();
        HashMap<Class<? extends BasicFileAttributes>, AttributeProvider> byAttributesTypeBuilder = new HashMap<Class<? extends BasicFileAttributes>, AttributeProvider>();
        ArrayList defaultAttributesBuilder = new ArrayList();
        for (AttributeProvider attributeProvider : providers) {
            byViewNameBuilder.put(attributeProvider.name(), attributeProvider);
            byViewTypeBuilder.put(attributeProvider.viewType(), attributeProvider);
            if (attributeProvider.attributesType() != null) {
                byAttributesTypeBuilder.put(attributeProvider.attributesType(), attributeProvider);
            }
            for (Map.Entry<String, ?> entry : attributeProvider.defaultValues(userProvidedDefaults).entrySet()) {
                defaultAttributesBuilder.add(new SimpleFileAttribute(entry.getKey(), entry.getValue()));
            }
        }
        this.providersByName = Map.copyOf(byViewNameBuilder);
        this.providersByViewType = Map.copyOf(byViewTypeBuilder);
        this.providersByAttributesType = Map.copyOf(byAttributesTypeBuilder);
        this.defaultValues = List.copyOf(defaultAttributesBuilder);
    }

    private static Iterable<AttributeProvider> getProviders(Configuration configuration) {
        HashMap<String, AttributeProvider> result = new HashMap<String, AttributeProvider>();
        for (AttributeProvider provider : configuration.attributeProviders) {
            result.put(provider.name(), provider);
        }
        for (String view : configuration.attributeViews) {
            AttributeService.addStandardProvider(result, view);
        }
        AttributeService.addMissingProviders(result);
        return Collections.unmodifiableCollection(result.values());
    }

    private static void addMissingProviders(Map<String, AttributeProvider> providers) {
        HashSet<String> missingViews = new HashSet<String>();
        for (AttributeProvider provider : providers.values()) {
            for (String inheritedView : provider.inherits()) {
                if (providers.containsKey(inheritedView)) continue;
                missingViews.add(inheritedView);
            }
        }
        if (missingViews.isEmpty()) {
            return;
        }
        for (String view : missingViews) {
            AttributeService.addStandardProvider(providers, view);
        }
        AttributeService.addMissingProviders(providers);
    }

    private static void addStandardProvider(Map<String, AttributeProvider> result, String view) {
        AttributeProvider provider = StandardAttributeProviders.get(view);
        if (provider == null) {
            if (!result.containsKey(view)) {
                throw new IllegalStateException("no provider found for attribute view '" + view + "'");
            }
        } else {
            result.put(provider.name(), provider);
        }
    }

    public Set<String> supportedFileAttributeViews() {
        return this.providersByName.keySet();
    }

    public boolean supportsFileAttributeView(Class<? extends FileAttributeView> type) {
        return this.providersByViewType.containsKey(type);
    }

    public void setInitialAttributes(File file, FileAttribute<?> ... attrs) {
        for (int i = 0; i < this.defaultValues.size(); ++i) {
            FileAttribute<?> attribute = this.defaultValues.get(i);
            int separatorIndex = attribute.name().indexOf(58);
            String view = attribute.name().substring(0, separatorIndex);
            String attr = attribute.name().substring(separatorIndex + 1);
            file.setAttribute(view, attr, attribute.value());
        }
        for (FileAttribute<?> attr : attrs) {
            this.setAttribute(file, attr.name(), attr.value(), true);
        }
    }

    public void copyAttributes(File file, File copy, AttributeCopyOption copyOption) {
        switch (copyOption) {
            case ALL: {
                file.copyAttributes(copy);
                break;
            }
            case BASIC: {
                file.copyBasicAttributes(copy);
                break;
            }
        }
    }

    public Object getAttribute(File file, String attribute) {
        String view = AttributeService.getViewName(attribute);
        String attr = AttributeService.getSingleAttribute(attribute);
        return this.getAttribute(file, view, attr);
    }

    public Object getAttribute(File file, String view, String attribute) {
        Object value = this.getAttributeInternal(file, view, attribute);
        if (value == null) {
            throw new IllegalArgumentException("invalid attribute for view '" + view + "': " + attribute);
        }
        return value;
    }

    private Object getAttributeInternal(File file, String view, String attribute) {
        Object value;
        block2: {
            String inheritedView;
            AttributeProvider provider = this.providersByName.get(view);
            if (provider == null) {
                return null;
            }
            value = provider.get(file, attribute);
            if (value != null) break block2;
            Iterator<String> iterator = provider.inherits().iterator();
            while (iterator.hasNext() && (value = this.getAttributeInternal(file, inheritedView = iterator.next(), attribute)) == null) {
            }
        }
        return value;
    }

    public void setAttribute(File file, String attribute, Object value, boolean create) {
        String view = AttributeService.getViewName(attribute);
        String attr = AttributeService.getSingleAttribute(attribute);
        this.setAttributeInternal(file, view, attr, value, create);
    }

    private void setAttributeInternal(File file, String view, String attribute, Object value, boolean create) {
        AttributeProvider provider = this.providersByName.get(view);
        if (provider != null) {
            if (provider.supports(attribute)) {
                provider.set(file, view, attribute, value, create);
                return;
            }
            for (String inheritedView : provider.inherits()) {
                AttributeProvider inheritedProvider = this.providersByName.get(inheritedView);
                if (!inheritedProvider.supports(attribute)) continue;
                inheritedProvider.set(file, view, attribute, value, create);
                return;
            }
        }
        throw new UnsupportedOperationException("cannot set attribute '" + view + ":" + attribute + "'");
    }

    public <V extends FileAttributeView> V getFileAttributeView(FileLookup lookup, Class<V> type) {
        AttributeProvider provider = this.providersByViewType.get(type);
        if (provider != null) {
            return (V)provider.view(lookup, this.createInheritedViews(lookup, provider));
        }
        return null;
    }

    private FileAttributeView getFileAttributeView(FileLookup lookup, Class<? extends FileAttributeView> viewType, Map<String, FileAttributeView> inheritedViews) {
        AttributeProvider provider = this.providersByViewType.get(viewType);
        this.createInheritedViews(lookup, provider, inheritedViews);
        return provider.view(lookup, Map.copyOf(inheritedViews));
    }

    private Map<String, FileAttributeView> createInheritedViews(FileLookup lookup, AttributeProvider provider) {
        if (provider.inherits().isEmpty()) {
            return Map.of();
        }
        HashMap<String, FileAttributeView> inheritedViews = new HashMap<String, FileAttributeView>();
        this.createInheritedViews(lookup, provider, inheritedViews);
        return Map.copyOf(inheritedViews);
    }

    private void createInheritedViews(FileLookup lookup, AttributeProvider provider, Map<String, FileAttributeView> inheritedViews) {
        for (String inherited : provider.inherits()) {
            if (inheritedViews.containsKey(inherited)) continue;
            AttributeProvider inheritedProvider = this.providersByName.get(inherited);
            FileAttributeView inheritedView = this.getFileAttributeView(lookup, inheritedProvider.viewType(), inheritedViews);
            inheritedViews.put(inherited, inheritedView);
        }
    }

    public Map<String, Object> readAttributes(File file, String attributes) {
        String view = AttributeService.getViewName(attributes);
        List<String> attrs = AttributeService.getAttributeNames(attributes);
        if (attrs.size() > 1 && attrs.contains(ALL_ATTRIBUTES)) {
            throw new IllegalArgumentException("invalid attributes: " + attributes);
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (attrs.size() == 1 && attrs.contains(ALL_ATTRIBUTES)) {
            AttributeProvider provider = this.providersByName.get(view);
            AttributeService.readAll(file, provider, result);
            for (String inheritedView : provider.inherits()) {
                AttributeProvider inheritedProvider = this.providersByName.get(inheritedView);
                AttributeService.readAll(file, inheritedProvider, result);
            }
        } else {
            for (String attr : attrs) {
                result.put(attr, this.getAttribute(file, view, attr));
            }
        }
        return Map.copyOf(result);
    }

    public <A extends BasicFileAttributes> A readAttributes(File file, Class<A> type) {
        AttributeProvider provider = this.providersByAttributesType.get(type);
        if (provider != null) {
            return (A)provider.readAttributes(file);
        }
        throw new UnsupportedOperationException("unsupported attributes type: " + String.valueOf(type));
    }

    private static void readAll(File file, AttributeProvider provider, Map<String, Object> map) {
        for (String attribute : provider.attributes(file)) {
            Object value = provider.get(file, attribute);
            if (value == null) continue;
            map.put(attribute, value);
        }
    }

    private static String getViewName(String attribute) {
        int separatorIndex = attribute.indexOf(58);
        if (separatorIndex == -1) {
            return "basic";
        }
        if (separatorIndex == 0 || separatorIndex == attribute.length() - 1 || attribute.indexOf(58, separatorIndex + 1) != -1) {
            throw new IllegalArgumentException("illegal attribute format: " + attribute);
        }
        return attribute.substring(0, separatorIndex);
    }

    private static List<String> getAttributeNames(String attributes) {
        int separatorIndex = attributes.indexOf(58);
        String attributesPart = attributes.substring(separatorIndex + 1);
        ArrayList<String> result = new ArrayList<String>();
        for (String part : attributesPart.split(ATTRIBUTE_SPLITTER)) {
            result.add(part);
        }
        return List.copyOf(result);
    }

    private static String getSingleAttribute(String attribute) {
        List<String> attributeNames = AttributeService.getAttributeNames(attribute);
        if (attributeNames.size() != 1 || ALL_ATTRIBUTES.equals(attributeNames.get(0))) {
            throw new IllegalArgumentException("must specify a single attribute: " + attribute);
        }
        return attributeNames.get(0);
    }

    private static final class SimpleFileAttribute<T>
    implements FileAttribute<T> {
        private final String name;
        private final T value;

        SimpleFileAttribute(String name, T value) {
            this.name = Objects.requireNonNull(name);
            this.value = Objects.requireNonNull(value);
        }

        @Override
        public String name() {
            return this.name;
        }

        @Override
        public T value() {
            return this.value;
        }
    }
}

