/*
 * Decompiled with CFR 0.152.
 */
package io.roastedroot.zerofs;

import io.roastedroot.zerofs.AttributeProvider;
import io.roastedroot.zerofs.Feature;
import io.roastedroot.zerofs.FileTimeSource;
import io.roastedroot.zerofs.PathNormalization;
import io.roastedroot.zerofs.PathType;
import io.roastedroot.zerofs.SystemFileTimeSource;
import io.roastedroot.zerofs.WatchServiceConfiguration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;

public final class Configuration {
    final PathType pathType;
    final Set<PathNormalization> nameDisplayNormalization;
    final Set<PathNormalization> nameCanonicalNormalization;
    final boolean pathEqualityUsesCanonicalForm;
    final int blockSize;
    final long maxSize;
    final long maxCacheSize;
    final Set<String> attributeViews;
    final Set<AttributeProvider> attributeProviders;
    final Map<String, Object> defaultAttributeValues;
    final FileTimeSource fileTimeSource;
    final WatchServiceConfiguration watchServiceConfig;
    final Set<String> roots;
    final String workingDirectory;
    final Set<Feature> supportedFeatures;
    private final String displayName;

    public static Configuration unix() {
        return UnixHolder.UNIX;
    }

    public static Configuration osX() {
        return OsxHolder.OS_X;
    }

    public static Configuration windows() {
        return WindowsHolder.WINDOWS;
    }

    public static Configuration forCurrentPlatform() {
        String os = System.getProperty("os.name");
        if (os.contains("Windows")) {
            return Configuration.windows();
        }
        if (os.contains("OS X")) {
            return Configuration.osX();
        }
        return Configuration.unix();
    }

    public static Builder builder(PathType pathType) {
        return new Builder(pathType);
    }

    private Configuration(Builder builder) {
        this.pathType = builder.pathType;
        this.nameDisplayNormalization = builder.nameDisplayNormalization;
        this.nameCanonicalNormalization = builder.nameCanonicalNormalization;
        this.pathEqualityUsesCanonicalForm = builder.pathEqualityUsesCanonicalForm;
        this.blockSize = builder.blockSize;
        this.maxSize = builder.maxSize;
        this.maxCacheSize = builder.maxCacheSize;
        this.attributeViews = builder.attributeViews;
        this.attributeProviders = builder.attributeProviders == null ? Set.of() : Set.copyOf(builder.attributeProviders);
        this.defaultAttributeValues = builder.defaultAttributeValues == null ? Map.of() : Map.copyOf(builder.defaultAttributeValues);
        this.fileTimeSource = builder.fileTimeSource;
        this.watchServiceConfig = builder.watchServiceConfig;
        this.roots = builder.roots;
        this.workingDirectory = builder.workingDirectory;
        this.supportedFeatures = builder.supportedFeatures;
        this.displayName = builder.displayName;
    }

    public String toString() {
        return "Configuration{pathType=" + String.valueOf(this.pathType) + ", nameDisplayNormalization=" + String.valueOf(this.nameDisplayNormalization) + ", nameCanonicalNormalization=" + String.valueOf(this.nameCanonicalNormalization) + ", pathEqualityUsesCanonicalForm=" + this.pathEqualityUsesCanonicalForm + ", blockSize=" + this.blockSize + ", maxSize=" + this.maxSize + ", maxCacheSize=" + this.maxCacheSize + ", attributeViews=" + String.valueOf(this.attributeViews) + ", attributeProviders=" + String.valueOf(this.attributeProviders) + ", defaultAttributeValues=" + String.valueOf(this.defaultAttributeValues) + ", fileTimeSource=" + String.valueOf(this.fileTimeSource) + ", watchServiceConfig=" + String.valueOf(this.watchServiceConfig) + ", roots=" + String.valueOf(this.roots) + ", workingDirectory='" + this.workingDirectory + "', supportedFeatures=" + String.valueOf(this.supportedFeatures) + ", displayName='" + this.displayName + "'}";
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static final class Builder {
        public static final int DEFAULT_BLOCK_SIZE = 8192;
        public static final long DEFAULT_MAX_SIZE = 0x100000000L;
        public static final long DEFAULT_MAX_CACHE_SIZE = -1L;
        private final PathType pathType;
        private Set<PathNormalization> nameDisplayNormalization = Set.of();
        private Set<PathNormalization> nameCanonicalNormalization = Set.of();
        private boolean pathEqualityUsesCanonicalForm = false;
        private int blockSize = 8192;
        private long maxSize = 0x100000000L;
        private long maxCacheSize = -1L;
        private Set<String> attributeViews = Set.of();
        private Set<AttributeProvider> attributeProviders = null;
        private Map<String, Object> defaultAttributeValues;
        private FileTimeSource fileTimeSource = SystemFileTimeSource.INSTANCE;
        private WatchServiceConfiguration watchServiceConfig = WatchServiceConfiguration.DEFAULT;
        private Set<String> roots = Set.of();
        private String workingDirectory;
        private Set<Feature> supportedFeatures = Set.of();
        private String displayName;
        private static final Pattern ATTRIBUTE_PATTERN = Pattern.compile("[^:]+:[^:]+");

        private Builder(PathType pathType) {
            this.pathType = Objects.requireNonNull(pathType);
        }

        private Builder(Configuration configuration) {
            this.pathType = configuration.pathType;
            this.nameDisplayNormalization = configuration.nameDisplayNormalization;
            this.nameCanonicalNormalization = configuration.nameCanonicalNormalization;
            this.pathEqualityUsesCanonicalForm = configuration.pathEqualityUsesCanonicalForm;
            this.blockSize = configuration.blockSize;
            this.maxSize = configuration.maxSize;
            this.maxCacheSize = configuration.maxCacheSize;
            this.attributeViews = configuration.attributeViews;
            this.attributeProviders = configuration.attributeProviders.isEmpty() ? null : new HashSet<AttributeProvider>(configuration.attributeProviders);
            this.defaultAttributeValues = configuration.defaultAttributeValues.isEmpty() ? null : new HashMap<String, Object>(configuration.defaultAttributeValues);
            this.fileTimeSource = configuration.fileTimeSource;
            this.watchServiceConfig = configuration.watchServiceConfig;
            this.roots = configuration.roots;
            this.workingDirectory = configuration.workingDirectory;
            this.supportedFeatures = configuration.supportedFeatures;
        }

        public Builder setNameDisplayNormalization(PathNormalization first, PathNormalization ... more) {
            ArrayList<PathNormalization> list = new ArrayList<PathNormalization>(more.length + 1);
            list.add(first);
            list.addAll(List.of(more));
            this.nameDisplayNormalization = this.checkNormalizations(list);
            return this;
        }

        public Builder setNameCanonicalNormalization(PathNormalization first, PathNormalization ... more) {
            ArrayList<PathNormalization> list = new ArrayList<PathNormalization>();
            list.add(first);
            list.addAll(List.of(more));
            this.nameCanonicalNormalization = this.checkNormalizations(list);
            return this;
        }

        private Set<PathNormalization> checkNormalizations(List<PathNormalization> normalizations) {
            PathNormalization none = null;
            PathNormalization normalization = null;
            PathNormalization caseFold = null;
            block5: for (PathNormalization n : normalizations) {
                Objects.requireNonNull(n);
                Builder.checkNormalizationNotSet(n, none);
                switch (n) {
                    case NONE: {
                        none = n;
                        continue block5;
                    }
                    case NFC: 
                    case NFD: {
                        Builder.checkNormalizationNotSet(n, normalization);
                        normalization = n;
                        continue block5;
                    }
                    case CASE_FOLD_UNICODE: 
                    case CASE_FOLD_ASCII: {
                        Builder.checkNormalizationNotSet(n, caseFold);
                        caseFold = n;
                        continue block5;
                    }
                }
                throw new AssertionError();
            }
            if (none != null) {
                return Set.of();
            }
            return Set.copyOf(normalizations);
        }

        private static void checkNormalizationNotSet(PathNormalization n, PathNormalization set) {
            if (set != null) {
                throw new IllegalArgumentException("can't set normalization " + String.valueOf(n) + ": normalization " + String.valueOf(set) + " already set");
            }
        }

        public Builder setPathEqualityUsesCanonicalForm(boolean useCanonicalForm) {
            this.pathEqualityUsesCanonicalForm = useCanonicalForm;
            return this;
        }

        public Builder setBlockSize(int blockSize) {
            if (blockSize <= 0) {
                throw new IllegalArgumentException(String.format("blockSize (%s) must be positive", blockSize));
            }
            this.blockSize = blockSize;
            return this;
        }

        public Builder setMaxSize(long maxSize) {
            if (maxSize <= 0L) {
                throw new IllegalArgumentException(String.format("maxSize (%s) must be positive", maxSize));
            }
            this.maxSize = maxSize;
            return this;
        }

        public Builder setMaxCacheSize(long maxCacheSize) {
            if (maxCacheSize < 0L) {
                throw new IllegalArgumentException(String.format("maxCacheSize (%s) may not be negative", maxCacheSize));
            }
            this.maxCacheSize = maxCacheSize;
            return this;
        }

        public Builder setAttributeViews(String first, String ... more) {
            ArrayList<String> list = new ArrayList<String>();
            list.add(first);
            list.addAll(List.of(more));
            this.attributeViews = Set.copyOf(list);
            return this;
        }

        public Builder addAttributeProvider(AttributeProvider provider) {
            Objects.requireNonNull(provider);
            if (this.attributeProviders == null) {
                this.attributeProviders = new HashSet<AttributeProvider>();
            }
            this.attributeProviders.add(provider);
            return this;
        }

        public Builder setDefaultAttributeValue(String attribute, Object value) {
            if (!ATTRIBUTE_PATTERN.matcher(attribute).matches()) {
                throw new IllegalArgumentException(String.format("attribute (%s) must be of the form \"view:attribute\"", attribute));
            }
            Objects.requireNonNull(value);
            if (this.defaultAttributeValues == null) {
                this.defaultAttributeValues = new HashMap<String, Object>();
            }
            this.defaultAttributeValues.put(attribute, value);
            return this;
        }

        public Builder setFileTimeSource(FileTimeSource source) {
            this.fileTimeSource = Objects.requireNonNull(source);
            return this;
        }

        public Builder setRoots(String first, String ... more) {
            ArrayList<String> roots = new ArrayList<String>();
            roots.add(first);
            roots.addAll(List.of(more));
            for (String root : roots) {
                PathType.ParseResult parseResult = this.pathType.parsePath(root);
                if (parseResult.isRoot()) continue;
                throw new IllegalArgumentException(String.format("invalid root: %s", root));
            }
            this.roots = Set.copyOf(roots);
            return this;
        }

        public Builder setWorkingDirectory(String workingDirectory) {
            PathType.ParseResult parseResult = this.pathType.parsePath(workingDirectory);
            if (!parseResult.isAbsolute()) {
                throw new IllegalArgumentException(String.format("working directory must be an absolute path: %s", workingDirectory));
            }
            this.workingDirectory = Objects.requireNonNull(workingDirectory);
            return this;
        }

        public Builder setSupportedFeatures(Feature ... features) {
            this.supportedFeatures = Set.copyOf(List.of(features));
            return this;
        }

        public Builder setWatchServiceConfiguration(WatchServiceConfiguration config) {
            this.watchServiceConfig = Objects.requireNonNull(config);
            return this;
        }

        private Builder setDisplayName(String displayName) {
            this.displayName = Objects.requireNonNull(displayName);
            return this;
        }

        public Configuration build() {
            return new Configuration(this);
        }
    }

    private static final class WindowsHolder {
        private static final Configuration WINDOWS = Configuration.builder(PathType.windows()).setDisplayName("Windows").setRoots("C:\\", new String[0]).setWorkingDirectory("C:\\work").setNameCanonicalNormalization(PathNormalization.CASE_FOLD_ASCII, new PathNormalization[0]).setPathEqualityUsesCanonicalForm(true).setAttributeViews("basic", new String[0]).setSupportedFeatures(Feature.LINKS, Feature.SYMBOLIC_LINKS, Feature.FILE_CHANNEL).build();

        private WindowsHolder() {
        }
    }

    private static final class OsxHolder {
        private static final Configuration OS_X = Configuration.unix().toBuilder().setDisplayName("OSX").setNameDisplayNormalization(PathNormalization.NFC, new PathNormalization[0]).setNameCanonicalNormalization(PathNormalization.NFD, PathNormalization.CASE_FOLD_ASCII).setSupportedFeatures(Feature.LINKS, Feature.SYMBOLIC_LINKS, Feature.FILE_CHANNEL).build();

        private OsxHolder() {
        }
    }

    private static final class UnixHolder {
        private static final Configuration UNIX = Configuration.builder(PathType.unix()).setDisplayName("Unix").setRoots("/", new String[0]).setWorkingDirectory("/work").setAttributeViews("basic", new String[0]).setSupportedFeatures(Feature.LINKS, Feature.SYMBOLIC_LINKS, Feature.SECURE_DIRECTORY_STREAM, Feature.FILE_CHANNEL).build();

        private UnixHolder() {
        }
    }
}

