/*
 * Decompiled with CFR 0.152.
 */
package io.roastedroot.zerofs;

import io.roastedroot.zerofs.Directory;
import io.roastedroot.zerofs.File;
import io.roastedroot.zerofs.FileTimeSource;
import io.roastedroot.zerofs.HeapDisk;
import io.roastedroot.zerofs.Name;
import io.roastedroot.zerofs.RegularFile;
import io.roastedroot.zerofs.SymbolicLink;
import io.roastedroot.zerofs.ZeroFsPath;
import java.io.IOException;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;

final class FileFactory {
    private final AtomicInteger idGenerator = new AtomicInteger();
    private final HeapDisk disk;
    private final FileTimeSource fileTimeSource;
    private final Supplier<Directory> directorySupplier = new DirectorySupplier();
    private final Supplier<RegularFile> regularFileSupplier = new RegularFileSupplier();

    public FileFactory(HeapDisk disk, FileTimeSource fileTimeSource) {
        this.disk = Objects.requireNonNull(disk);
        this.fileTimeSource = Objects.requireNonNull(fileTimeSource);
    }

    private int nextFileId() {
        return this.idGenerator.getAndIncrement();
    }

    public Directory createDirectory() {
        return Directory.create(this.nextFileId(), this.fileTimeSource.now());
    }

    public Directory createRootDirectory(Name name) {
        return Directory.createRoot(this.nextFileId(), this.fileTimeSource.now(), name);
    }

    RegularFile createRegularFile() {
        return RegularFile.create(this.nextFileId(), this.fileTimeSource.now(), this.disk);
    }

    SymbolicLink createSymbolicLink(ZeroFsPath target) {
        return SymbolicLink.create(this.nextFileId(), this.fileTimeSource.now(), target);
    }

    public File copyWithoutContent(File file) throws IOException {
        return file.copyWithoutContent(this.nextFileId(), this.fileTimeSource.now());
    }

    public Supplier<Directory> directoryCreator() {
        return this.directorySupplier;
    }

    public Supplier<RegularFile> regularFileCreator() {
        return this.regularFileSupplier;
    }

    public Supplier<SymbolicLink> symbolicLinkCreator(ZeroFsPath target) {
        return new SymbolicLinkSupplier(target);
    }

    private final class SymbolicLinkSupplier
    implements Supplier<SymbolicLink> {
        private final ZeroFsPath target;

        protected SymbolicLinkSupplier(ZeroFsPath target) {
            this.target = Objects.requireNonNull(target);
        }

        @Override
        public SymbolicLink get() {
            return FileFactory.this.createSymbolicLink(this.target);
        }
    }

    private final class RegularFileSupplier
    implements Supplier<RegularFile> {
        private RegularFileSupplier() {
        }

        @Override
        public RegularFile get() {
            return FileFactory.this.createRegularFile();
        }
    }

    private final class DirectorySupplier
    implements Supplier<Directory> {
        private DirectorySupplier() {
        }

        @Override
        public Directory get() {
            return FileFactory.this.createDirectory();
        }
    }
}

