/*
 * Decompiled with CFR 0.152.
 */
package io.roastedroot.zerofs;

import io.roastedroot.zerofs.Directory;
import io.roastedroot.zerofs.DirectoryEntry;
import io.roastedroot.zerofs.File;
import io.roastedroot.zerofs.Name;
import io.roastedroot.zerofs.Options;
import io.roastedroot.zerofs.SymbolicLink;
import io.roastedroot.zerofs.ZeroFsPath;
import java.io.IOException;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;

final class FileTree {
    private static final int MAX_SYMBOLIC_LINK_DEPTH = 40;
    private static final List<Name> EMPTY_PATH_NAMES = List.of(Name.SELF);
    private final SortedMap<Name, Directory> roots = new TreeMap<Name, Directory>(Name.canonicalComparator());

    FileTree(Map<Name, Directory> roots) {
        this.roots.putAll(roots);
    }

    public SortedSet<Name> getRootDirectoryNames() {
        TreeSet<Name> result = new TreeSet<Name>(Name.canonicalComparator());
        result.addAll(this.roots.keySet());
        return result;
    }

    public DirectoryEntry getRoot(Name name) {
        Directory dir = (Directory)this.roots.get(name);
        return dir == null ? null : dir.entryInParent();
    }

    public DirectoryEntry lookUp(File workingDirectory, ZeroFsPath path, Set<? super LinkOption> options) throws IOException {
        Objects.requireNonNull(path);
        Objects.requireNonNull(options);
        DirectoryEntry result = this.lookUp(workingDirectory, path, options, 0);
        if (result == null) {
            throw new NoSuchFileException(path.toString());
        }
        return result;
    }

    private DirectoryEntry lookUp(File dir, ZeroFsPath path, Set<? super LinkOption> options, int linkDepth) throws IOException {
        List<Name> names = path.names();
        if (path.isAbsolute()) {
            DirectoryEntry entry = this.getRoot(path.root());
            if (entry == null) {
                return null;
            }
            if (names.isEmpty()) {
                return entry;
            }
            dir = entry.file();
        } else if (FileTree.isEmpty(names)) {
            names = EMPTY_PATH_NAMES;
        }
        return this.lookUp(dir, names, options, linkDepth);
    }

    private DirectoryEntry lookUp(File dir, Iterable<Name> names, Set<? super LinkOption> options, int linkDepth) throws IOException {
        Iterator<Name> nameIterator = names.iterator();
        Name name = nameIterator.next();
        while (nameIterator.hasNext()) {
            Directory directory = this.toDirectory(dir);
            if (directory == null) {
                return null;
            }
            DirectoryEntry entry = directory.get(name);
            if (entry == null) {
                return null;
            }
            File file = entry.file();
            if (file.isSymbolicLink()) {
                DirectoryEntry linkResult = this.followSymbolicLink(dir, (SymbolicLink)file, linkDepth);
                if (linkResult == null) {
                    return null;
                }
                dir = linkResult.fileOrNull();
            } else {
                dir = file;
            }
            name = nameIterator.next();
        }
        return this.lookUpLast(dir, name, options, linkDepth);
    }

    private DirectoryEntry lookUpLast(File dir, Name name, Set<? super LinkOption> options, int linkDepth) throws IOException {
        Directory directory = this.toDirectory(dir);
        if (directory == null) {
            return null;
        }
        DirectoryEntry entry = directory.get(name);
        if (entry == null) {
            return new DirectoryEntry(directory, name, null);
        }
        File file = entry.file();
        if (!options.contains(LinkOption.NOFOLLOW_LINKS) && file.isSymbolicLink()) {
            return this.followSymbolicLink(dir, (SymbolicLink)file, linkDepth);
        }
        return this.getRealEntry(entry);
    }

    private DirectoryEntry followSymbolicLink(File dir, SymbolicLink link, int linkDepth) throws IOException {
        if (linkDepth >= 40) {
            throw new IOException("too many levels of symbolic links");
        }
        return this.lookUp(dir, link.target(), Options.FOLLOW_LINKS, linkDepth + 1);
    }

    private DirectoryEntry getRealEntry(DirectoryEntry entry) {
        Name name = entry.name();
        if (name.equals(Name.SELF) || name.equals(Name.PARENT)) {
            Directory dir = this.toDirectory(entry.file());
            assert (dir != null);
            return dir.entryInParent();
        }
        return entry;
    }

    private Directory toDirectory(File file) {
        return file == null || !file.isDirectory() ? null : (Directory)file;
    }

    private static boolean isEmpty(List<Name> names) {
        return names.isEmpty() || names.size() == 1 && names.get(0).toString().isEmpty();
    }
}

