/*
 * Decompiled with CFR 0.152.
 */
package io.roastedroot.zerofs;

import io.roastedroot.zerofs.Configuration;
import io.roastedroot.zerofs.RegularFile;
import io.roastedroot.zerofs.SystemFileTimeSource;
import java.io.IOException;

final class HeapDisk {
    private final int blockSize;
    private final int maxBlockCount;
    private final int maxCachedBlockCount;
    final RegularFile blockCache;
    private int allocatedBlockCount;

    public HeapDisk(Configuration config) {
        this.blockSize = config.blockSize;
        this.maxBlockCount = HeapDisk.toBlockCount(config.maxSize, this.blockSize);
        this.maxCachedBlockCount = config.maxCacheSize == -1L ? this.maxBlockCount : HeapDisk.toBlockCount(config.maxCacheSize, this.blockSize);
        this.blockCache = this.createBlockCache(this.maxCachedBlockCount);
    }

    public HeapDisk(int blockSize, int maxBlockCount, int maxCachedBlockCount) {
        if (blockSize <= 0) {
            throw new IllegalArgumentException(String.format("blockSize (%s) must be positive", blockSize));
        }
        if (maxBlockCount <= 0) {
            throw new IllegalArgumentException(String.format("maxBlockCount (%s) must be positive", maxBlockCount));
        }
        if (maxCachedBlockCount < 0) {
            throw new IllegalArgumentException(String.format("maxCachedBlockCount (%s) must be non-negative", maxCachedBlockCount));
        }
        this.blockSize = blockSize;
        this.maxBlockCount = maxBlockCount;
        this.maxCachedBlockCount = maxCachedBlockCount;
        this.blockCache = this.createBlockCache(maxCachedBlockCount);
    }

    public static long divide(long p, long q) {
        long div = p / q;
        long rem = p - q * div;
        if (rem == 0L) {
            return div;
        }
        int signum = 1 | (int)((p ^ q) >> 63);
        boolean increment = signum < 0;
        return increment ? div + (long)signum : div;
    }

    private static int toBlockCount(long size, int blockSize) {
        return (int)HeapDisk.divide(size, blockSize);
    }

    private RegularFile createBlockCache(int maxCachedBlockCount) {
        return new RegularFile(-1, SystemFileTimeSource.INSTANCE.now(), this, new byte[Math.min(maxCachedBlockCount, 8192)][], 0, 0L);
    }

    public int blockSize() {
        return this.blockSize;
    }

    public synchronized long getTotalSpace() {
        return (long)this.maxBlockCount * (long)this.blockSize;
    }

    public synchronized long getUnallocatedSpace() {
        return (long)(this.maxBlockCount - this.allocatedBlockCount) * (long)this.blockSize;
    }

    public synchronized void allocate(RegularFile file, int count) throws IOException {
        int newAllocatedBlockCount = this.allocatedBlockCount + count;
        if (newAllocatedBlockCount > this.maxBlockCount) {
            throw new IOException("out of disk space");
        }
        int newBlocksNeeded = Math.max(count - this.blockCache.blockCount(), 0);
        for (int i = 0; i < newBlocksNeeded; ++i) {
            file.addBlock(new byte[this.blockSize]);
        }
        if (newBlocksNeeded != count) {
            this.blockCache.transferBlocksTo(file, count - newBlocksNeeded);
        }
        this.allocatedBlockCount = newAllocatedBlockCount;
    }

    public void free(RegularFile file) {
        this.free(file, file.blockCount());
    }

    public synchronized void free(RegularFile file, int count) {
        int remainingCacheSpace = this.maxCachedBlockCount - this.blockCache.blockCount();
        if (remainingCacheSpace > 0) {
            file.copyBlocksTo(this.blockCache, Math.min(count, remainingCacheSpace));
        }
        file.truncateBlocks(file.blockCount() - count);
        this.allocatedBlockCount -= count;
    }
}

