/*
 * Decompiled with CFR 0.152.
 */
package io.roastedroot.zerofs;

import java.util.Comparator;
import java.util.Objects;

final class Name {
    static final Name EMPTY = new Name("", "");
    public static final Name SELF = new Name(".", ".");
    public static final Name PARENT = new Name("..", "..");
    private final String display;
    private final String canonical;
    private static final Comparator<Name> DISPLAY_COMPARATOR = Comparator.comparing(n -> n.display);
    private static final Comparator<Name> CANONICAL_COMPARATOR = Comparator.comparing(n -> n.canonical);

    public static Name simple(String name) {
        switch (name) {
            case ".": {
                return SELF;
            }
            case "..": {
                return PARENT;
            }
        }
        return new Name(name, name);
    }

    public static Name create(String display, String canonical) {
        return new Name(display, canonical);
    }

    private Name(String display, String canonical) {
        this.display = Objects.requireNonNull(display);
        this.canonical = Objects.requireNonNull(canonical);
    }

    public boolean equals(Object obj) {
        if (obj instanceof Name) {
            Name other = (Name)obj;
            return this.canonical.equals(other.canonical);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode(this.canonical);
    }

    public String toString() {
        return this.display;
    }

    static Comparator<Name> displayComparator() {
        return DISPLAY_COMPARATOR;
    }

    static Comparator<Name> canonicalComparator() {
        return CANONICAL_COMPARATOR;
    }
}

