/*
 * Decompiled with CFR 0.152.
 */
package io.roastedroot.zerofs;

import io.roastedroot.zerofs.Util;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileTime;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.TimeZone;

final class PathURLConnection
extends URLConnection {
    private static final String HTTP_DATE_FORMAT = "EEE, dd MMM yyyy HH:mm:ss 'GMT'";
    private static final String DEFAULT_CONTENT_TYPE = "application/octet-stream";
    private InputStream stream;
    private Map<String, List<String>> headers = new HashMap<String, List<String>>();

    PathURLConnection(URL url) {
        super(Objects.requireNonNull(url));
    }

    public static <T> T firstNonNull(T first, T second) {
        if (first != null) {
            return first;
        }
        if (second != null) {
            return second;
        }
        throw new NullPointerException("Both parameters are null");
    }

    @Override
    public void connect() throws IOException {
        long length;
        if (this.stream != null) {
            return;
        }
        Path path = Paths.get(PathURLConnection.toUri(this.url));
        if (Files.isDirectory(path, new LinkOption[0])) {
            StringBuilder builder = new StringBuilder();
            try (DirectoryStream<Path> files = Files.newDirectoryStream(path);){
                for (Path file : files) {
                    builder.append(file.getFileName()).append('\n');
                }
            }
            byte[] bytes = builder.toString().getBytes(StandardCharsets.UTF_8);
            this.stream = new ByteArrayInputStream(bytes);
            length = bytes.length;
        } else {
            this.stream = Files.newInputStream(path, new OpenOption[0]);
            length = Files.size(path);
        }
        FileTime lastModified = Files.getLastModifiedTime(path, new LinkOption[0]);
        String contentType = PathURLConnection.firstNonNull(Files.probeContentType(path), DEFAULT_CONTENT_TYPE);
        HashMap<String, List<Object>> builder = new HashMap<String, List<Object>>();
        builder.put("content-length", List.of("" + length));
        builder.put("content-type", List.of(contentType));
        if (lastModified != null) {
            SimpleDateFormat format = new SimpleDateFormat(HTTP_DATE_FORMAT, Locale.US);
            format.setTimeZone(TimeZone.getTimeZone("GMT"));
            builder.put("last-modified", List.of(format.format(new Date(lastModified.toMillis()))));
        }
        this.headers = Map.copyOf(builder);
    }

    private static URI toUri(URL url) throws IOException {
        try {
            return url.toURI();
        }
        catch (URISyntaxException e) {
            throw new IOException("URL " + String.valueOf(url) + " cannot be converted to a URI", e);
        }
    }

    @Override
    public InputStream getInputStream() throws IOException {
        this.connect();
        return this.stream;
    }

    @Override
    public Map<String, List<String>> getHeaderFields() {
        try {
            this.connect();
        }
        catch (IOException e) {
            return Map.of();
        }
        return Map.copyOf(this.headers);
    }

    @Override
    public String getHeaderField(String name) {
        try {
            this.connect();
        }
        catch (IOException e) {
            return null;
        }
        List<String> result = this.headers.get(Util.toLowerCase(name));
        if (result != null && result.size() > 0) {
            return result.get(0);
        }
        return null;
    }
}

