/*
 * Decompiled with CFR 0.152.
 */
package io.roastedroot.zerofs;

import io.roastedroot.zerofs.AttributeProvider;
import io.roastedroot.zerofs.File;
import io.roastedroot.zerofs.FileLookup;
import io.roastedroot.zerofs.UnixFileAttributeView;
import java.nio.file.attribute.FileAttributeView;
import java.nio.file.attribute.GroupPrincipal;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.UserPrincipal;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;

final class UnixAttributeProvider
extends AttributeProvider {
    private static final Set<String> ATTRIBUTES = Set.of("uid", "ino", "dev", "nlink", "rdev", "ctime", "mode", "gid");
    private static final Set<String> INHERITED_VIEWS = Set.of("basic", "owner", "posix");
    private final AtomicInteger uidGenerator = new AtomicInteger();
    private final ConcurrentMap<Object, Integer> idCache = new ConcurrentHashMap<Object, Integer>();

    UnixAttributeProvider() {
    }

    @Override
    public String name() {
        return "unix";
    }

    @Override
    public Set<String> inherits() {
        return INHERITED_VIEWS;
    }

    @Override
    public Set<String> fixedAttributes() {
        return ATTRIBUTES;
    }

    public Class<UnixFileAttributeView> viewType() {
        return UnixFileAttributeView.class;
    }

    @Override
    public UnixFileAttributeView view(FileLookup lookup, Map<String, FileAttributeView> inheritedViews) {
        throw new UnsupportedOperationException();
    }

    private Integer getUniqueId(Object object) {
        Integer existing;
        Integer id = (Integer)this.idCache.get(object);
        if (id == null && (existing = this.idCache.putIfAbsent(object, id = Integer.valueOf(this.uidGenerator.incrementAndGet()))) != null) {
            return existing;
        }
        return id;
    }

    @Override
    public Object get(File file, String attribute) {
        switch (attribute) {
            case "uid": {
                UserPrincipal user = (UserPrincipal)file.getAttribute("owner", "owner");
                return this.getUniqueId(user);
            }
            case "gid": {
                GroupPrincipal group = (GroupPrincipal)file.getAttribute("posix", "group");
                return this.getUniqueId(group);
            }
            case "mode": {
                Set permissions = (Set)file.getAttribute("posix", "permissions");
                return UnixAttributeProvider.toMode(permissions);
            }
            case "ctime": {
                return file.getCreationTime();
            }
            case "rdev": {
                return 0L;
            }
            case "dev": {
                return 1L;
            }
            case "ino": {
                return file.id();
            }
            case "nlink": {
                return file.links();
            }
        }
        return null;
    }

    @Override
    public void set(File file, String view, String attribute, Object value, boolean create) {
        throw UnixAttributeProvider.unsettable(view, attribute, create);
    }

    private static int toMode(Set<PosixFilePermission> permissions) {
        int result = 0;
        block11: for (PosixFilePermission permission : permissions) {
            Objects.requireNonNull(permission);
            switch (permission) {
                case OWNER_READ: {
                    result |= 0x100;
                    continue block11;
                }
                case OWNER_WRITE: {
                    result |= 0x80;
                    continue block11;
                }
                case OWNER_EXECUTE: {
                    result |= 0x40;
                    continue block11;
                }
                case GROUP_READ: {
                    result |= 0x20;
                    continue block11;
                }
                case GROUP_WRITE: {
                    result |= 0x10;
                    continue block11;
                }
                case GROUP_EXECUTE: {
                    result |= 8;
                    continue block11;
                }
                case OTHERS_READ: {
                    result |= 4;
                    continue block11;
                }
                case OTHERS_WRITE: {
                    result |= 2;
                    continue block11;
                }
                case OTHERS_EXECUTE: {
                    result |= 1;
                    continue block11;
                }
            }
            throw new AssertionError();
        }
        return result;
    }
}

