/*
 * Decompiled with CFR 0.152.
 */
package io.roastedroot.zerofs;

import io.roastedroot.zerofs.AbstractAttributeView;
import io.roastedroot.zerofs.AttributeProvider;
import io.roastedroot.zerofs.File;
import io.roastedroot.zerofs.FileLookup;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.file.attribute.FileAttributeView;
import java.nio.file.attribute.UserDefinedFileAttributeView;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;

final class UserDefinedAttributeProvider
extends AttributeProvider {
    UserDefinedAttributeProvider() {
    }

    @Override
    public String name() {
        return "user";
    }

    @Override
    public Set<String> fixedAttributes() {
        return Set.of();
    }

    @Override
    public boolean supports(String attribute) {
        return true;
    }

    @Override
    public Set<String> attributes(File file) {
        return UserDefinedAttributeProvider.userDefinedAttributes(file);
    }

    private static Set<String> userDefinedAttributes(File file) {
        TreeSet<String> builder = new TreeSet<String>();
        for (String attribute : file.getAttributeNames("user")) {
            builder.add(attribute);
        }
        return Set.copyOf(builder);
    }

    @Override
    public Object get(File file, String attribute) {
        Object value = file.getAttribute("user", attribute);
        if (value instanceof byte[]) {
            byte[] bytes = (byte[])value;
            return bytes.clone();
        }
        return null;
    }

    @Override
    public void set(File file, String view, String attribute, Object value, boolean create) {
        byte[] bytes;
        Objects.requireNonNull(value);
        UserDefinedAttributeProvider.checkNotCreate(view, attribute, create);
        if (value instanceof byte[]) {
            bytes = (byte[])((byte[])value).clone();
        } else if (value instanceof ByteBuffer) {
            ByteBuffer buffer = (ByteBuffer)value;
            bytes = new byte[buffer.remaining()];
            buffer.get(bytes);
        } else {
            throw UserDefinedAttributeProvider.invalidType(view, attribute, value, byte[].class, ByteBuffer.class);
        }
        file.setAttribute("user", attribute, bytes);
    }

    public Class<UserDefinedFileAttributeView> viewType() {
        return UserDefinedFileAttributeView.class;
    }

    @Override
    public UserDefinedFileAttributeView view(FileLookup lookup, Map<String, FileAttributeView> inheritedViews) {
        return new View(lookup);
    }

    private static class View
    extends AbstractAttributeView
    implements UserDefinedFileAttributeView {
        public View(FileLookup lookup) {
            super(lookup);
        }

        @Override
        public String name() {
            return "user";
        }

        @Override
        public List<String> list() throws IOException {
            return List.copyOf(UserDefinedAttributeProvider.userDefinedAttributes(this.lookupFile()));
        }

        private byte[] getStoredBytes(String name) throws IOException {
            byte[] bytes = (byte[])this.lookupFile().getAttribute(this.name(), name);
            if (bytes == null) {
                throw new IllegalArgumentException("attribute '" + this.name() + ":" + name + "' is not set");
            }
            return bytes;
        }

        @Override
        public int size(String name) throws IOException {
            return this.getStoredBytes(name).length;
        }

        @Override
        public int read(String name, ByteBuffer dst) throws IOException {
            byte[] bytes = this.getStoredBytes(name);
            dst.put(bytes);
            return bytes.length;
        }

        @Override
        public int write(String name, ByteBuffer src) throws IOException {
            byte[] bytes = new byte[src.remaining()];
            src.get(bytes);
            this.lookupFile().setAttribute(this.name(), name, bytes);
            return bytes.length;
        }

        @Override
        public void delete(String name) throws IOException {
            this.lookupFile().deleteAttribute(this.name(), name);
        }
    }
}

