/*
 * Decompiled with CFR 0.152.
 */
package io.roastedroot.zerofs;

import java.io.IOException;
import java.nio.file.attribute.GroupPrincipal;
import java.nio.file.attribute.UserPrincipal;
import java.nio.file.attribute.UserPrincipalLookupService;
import java.nio.file.attribute.UserPrincipalNotFoundException;
import java.util.Objects;

final class UserLookupService
extends UserPrincipalLookupService {
    private final boolean supportsGroups;

    public UserLookupService(boolean supportsGroups) {
        this.supportsGroups = supportsGroups;
    }

    @Override
    public UserPrincipal lookupPrincipalByName(String name) {
        return UserLookupService.createUserPrincipal(name);
    }

    @Override
    public GroupPrincipal lookupPrincipalByGroupName(String group) throws IOException {
        if (!this.supportsGroups) {
            throw new UserPrincipalNotFoundException(group);
        }
        return UserLookupService.createGroupPrincipal(group);
    }

    static UserPrincipal createUserPrincipal(String name) {
        return new ZeroFsUserPrincipal(name);
    }

    static GroupPrincipal createGroupPrincipal(String name) {
        return new ZeroFsGroupPrincipal(name);
    }

    static final class ZeroFsGroupPrincipal
    extends NamedPrincipal
    implements GroupPrincipal {
        private ZeroFsGroupPrincipal(String name) {
            super(name);
        }

        @Override
        public boolean equals(Object obj) {
            return obj instanceof ZeroFsGroupPrincipal && ((ZeroFsGroupPrincipal)obj).name.equals(this.name);
        }
    }

    static final class ZeroFsUserPrincipal
    extends NamedPrincipal {
        private ZeroFsUserPrincipal(String name) {
            super(name);
        }

        @Override
        public boolean equals(Object obj) {
            return obj instanceof ZeroFsUserPrincipal && this.getName().equals(((ZeroFsUserPrincipal)obj).getName());
        }
    }

    private static abstract class NamedPrincipal
    implements UserPrincipal {
        protected final String name;

        private NamedPrincipal(String name) {
            this.name = Objects.requireNonNull(name);
        }

        @Override
        public final String getName() {
            return this.name;
        }

        @Override
        public final int hashCode() {
            return this.name.hashCode();
        }

        @Override
        public final String toString() {
            return this.name;
        }
    }
}

