/*
 * Decompiled with CFR 0.152.
 */
package io.roastedroot.zerofs;

import io.roastedroot.zerofs.AbstractWatchService;
import io.roastedroot.zerofs.FileSystemView;
import io.roastedroot.zerofs.PathService;
import io.roastedroot.zerofs.PollingWatchService;
import java.util.Objects;
import java.util.concurrent.TimeUnit;

public abstract class WatchServiceConfiguration {
    static final WatchServiceConfiguration DEFAULT = WatchServiceConfiguration.polling(5L, TimeUnit.SECONDS);

    public static WatchServiceConfiguration polling(long interval, TimeUnit timeUnit) {
        return new PollingConfig(interval, timeUnit);
    }

    WatchServiceConfiguration() {
    }

    abstract AbstractWatchService newWatchService(FileSystemView var1, PathService var2);

    private static final class PollingConfig
    extends WatchServiceConfiguration {
        private final long interval;
        private final TimeUnit timeUnit;

        private PollingConfig(long interval, TimeUnit timeUnit) {
            if (interval <= 0L) {
                throw new IllegalArgumentException(String.format("interval (%s) must be positive", interval));
            }
            this.interval = interval;
            this.timeUnit = Objects.requireNonNull(timeUnit);
        }

        @Override
        AbstractWatchService newWatchService(FileSystemView view, PathService pathService) {
            return new PollingWatchService(view, pathService, view.state(), this.interval, this.timeUnit);
        }

        public String toString() {
            return "WatchServiceConfiguration.polling(" + this.interval + ", " + String.valueOf((Object)this.timeUnit) + ")";
        }
    }
}

