/*
 * Decompiled with CFR 0.152.
 */
package io.roastedroot.zerofs;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class WeakValueConcurrentMap<K, V>
implements ConcurrentMap<K, V> {
    private final ConcurrentMap<K, WeakValue<K, V>> map = new ConcurrentHashMap<K, WeakValue<K, V>>();
    private final ReferenceQueue<V> queue = new ReferenceQueue();

    private void processQueue() {
        WeakValue ref;
        while ((ref = (WeakValue)this.queue.poll()) != null) {
            this.map.remove(ref.key, ref);
        }
    }

    @Override
    public V get(Object key) {
        this.processQueue();
        WeakValue ref = (WeakValue)this.map.get(key);
        return ref == null ? null : (V)ref.get();
    }

    @Override
    public V put(K key, V value) {
        this.processQueue();
        WeakValue<K, V> ref = new WeakValue<K, V>(key, value, this.queue);
        WeakValue<K, V> previous = this.map.put(key, ref);
        return previous == null ? null : (V)previous.get();
    }

    @Override
    public V putIfAbsent(K key, V value) {
        this.processQueue();
        WeakValue<K, V> newRef = new WeakValue<K, V>(key, value, this.queue);
        WeakValue<K, V> existing;
        while ((existing = this.map.putIfAbsent(key, newRef)) != null) {
            Object existingVal = existing.get();
            if (existingVal != null) {
                return (V)existingVal;
            }
            this.map.remove(key, existing);
        }
        return null;
    }

    @Override
    public boolean remove(Object key, Object value) {
        this.processQueue();
        WeakValue ref = (WeakValue)this.map.get(key);
        if (ref != null && value.equals(ref.get())) {
            return this.map.remove(key, ref);
        }
        return false;
    }

    @Override
    public boolean replace(K key, V oldValue, V newValue) {
        this.processQueue();
        WeakValue existing = (WeakValue)this.map.get(key);
        if (existing != null && oldValue.equals(existing.get())) {
            return this.map.replace(key, existing, new WeakValue<K, V>(key, newValue, this.queue));
        }
        return false;
    }

    @Override
    public V replace(K key, V value) {
        this.processQueue();
        WeakValue existing = (WeakValue)this.map.get(key);
        if (existing != null && existing.get() != null) {
            WeakValue<K, V> replaced = this.map.replace(key, new WeakValue<K, V>(key, value, this.queue));
            return replaced == null ? null : (V)replaced.get();
        }
        return null;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        this.processQueue();
        for (Map.Entry<K, V> entry : m.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public V remove(Object key) {
        this.processQueue();
        WeakValue ref = (WeakValue)this.map.remove(key);
        return ref == null ? null : (V)ref.get();
    }

    @Override
    public void clear() {
        this.map.clear();
        while (this.queue.poll() != null) {
        }
    }

    @Override
    public boolean containsKey(Object key) {
        return this.get(key) != null;
    }

    @Override
    public boolean containsValue(Object value) {
        this.processQueue();
        for (WeakValue ref : this.map.values()) {
            if (!value.equals(ref.get())) continue;
            return true;
        }
        return false;
    }

    @Override
    public Set<K> keySet() {
        this.processQueue();
        return this.map.keySet();
    }

    @Override
    public int size() {
        this.processQueue();
        int count = 0;
        for (WeakValue ref : this.map.values()) {
            if (ref.get() == null) continue;
            ++count;
        }
        return count;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        throw new UnsupportedOperationException("entrySet not supported due to weak values");
    }

    @Override
    public Collection<V> values() {
        throw new UnsupportedOperationException("values() not supported due to weak references");
    }

    private static class WeakValue<K, V>
    extends WeakReference<V> {
        final K key;

        WeakValue(K key, V value, ReferenceQueue<V> queue) {
            super(value, queue);
            this.key = key;
        }
    }
}

