/*
 * Decompiled with CFR 0.152.
 */
package io.roastedroot.zerofs;

import io.roastedroot.zerofs.Configuration;
import io.roastedroot.zerofs.SystemZeroFsFileSystemProvider;
import io.roastedroot.zerofs.ZeroFsFileSystem;
import io.roastedroot.zerofs.ZeroFsFileSystemProvider;
import io.roastedroot.zerofs.ZeroFsFileSystems;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.ProviderNotFoundException;
import java.nio.file.spi.FileSystemProvider;
import java.util.Map;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class ZeroFs {
    public static final String URI_SCHEME = "zerofs";
    private static final Logger LOGGER = Logger.getLogger(ZeroFs.class.getName());
    static final FileSystemProvider systemProvider = ZeroFs.getSystemZeroFsProvider();

    private ZeroFs() {
    }

    public static FileSystem newFileSystem() {
        return ZeroFs.newFileSystem(ZeroFs.newRandomFileSystemName());
    }

    public static FileSystem newFileSystem(String name) {
        return ZeroFs.newFileSystem(name, Configuration.forCurrentPlatform());
    }

    public static FileSystem newFileSystem(Configuration configuration) {
        return ZeroFs.newFileSystem(ZeroFs.newRandomFileSystemName(), configuration);
    }

    public static FileSystem newFileSystem(String name, Configuration configuration) {
        try {
            URI uri = new URI(URI_SCHEME, name, null, null);
            return ZeroFs.newFileSystem(uri, configuration);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }

    static FileSystem newFileSystem(URI uri, Configuration config) {
        if (!URI_SCHEME.equals(uri.getScheme())) {
            throw new IllegalArgumentException(String.format("uri (%s) must have scheme %s", uri, URI_SCHEME));
        }
        try {
            ZeroFsFileSystem fileSystem = ZeroFsFileSystems.newFileSystem(ZeroFsFileSystemProvider.instance(), uri, config);
            try {
                Map<String, ZeroFsFileSystem> env = Map.of("fileSystem", fileSystem);
                FileSystems.newFileSystem(uri, env, SystemZeroFsFileSystemProvider.class.getClassLoader());
            }
            catch (ProviderNotFoundException | ServiceConfigurationError throwable) {
                // empty catch block
            }
            return fileSystem;
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    private static FileSystemProvider getSystemZeroFsProvider() {
        try {
            for (FileSystemProvider provider : FileSystemProvider.installedProviders()) {
                if (!provider.getScheme().equals(URI_SCHEME)) continue;
                return provider;
            }
            ServiceLoader<FileSystemProvider> loader = ServiceLoader.load(FileSystemProvider.class, SystemZeroFsFileSystemProvider.class.getClassLoader());
            for (FileSystemProvider provider : loader) {
                if (!provider.getScheme().equals(URI_SCHEME)) continue;
                return provider;
            }
        }
        catch (ProviderNotFoundException | ServiceConfigurationError e) {
            LOGGER.log(Level.INFO, "An exception occurred when attempting to find the system-loaded FileSystemProvider for ZeroFs. This likely means that your environment does not support loading services via ServiceLoader or is not configured correctly. This does not prevent using ZeroFs, but it will mean that methods that look up via URI such as Paths.get(URI) cannot work.", e);
        }
        return null;
    }

    private static String newRandomFileSystemName() {
        return UUID.randomUUID().toString();
    }
}

