/*
 * Decompiled with CFR 0.152.
 */
package io.roastedroot.zerofs;

import io.roastedroot.zerofs.AttributeService;
import io.roastedroot.zerofs.Configuration;
import io.roastedroot.zerofs.Directory;
import io.roastedroot.zerofs.FileFactory;
import io.roastedroot.zerofs.FileSystemState;
import io.roastedroot.zerofs.FileSystemView;
import io.roastedroot.zerofs.FileTree;
import io.roastedroot.zerofs.HeapDisk;
import io.roastedroot.zerofs.Name;
import io.roastedroot.zerofs.PathService;
import io.roastedroot.zerofs.WatchServiceConfiguration;
import io.roastedroot.zerofs.ZeroFs;
import io.roastedroot.zerofs.ZeroFsFileStore;
import io.roastedroot.zerofs.ZeroFsFileSystem;
import io.roastedroot.zerofs.ZeroFsFileSystemProvider;
import io.roastedroot.zerofs.ZeroFsPath;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URI;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;

final class ZeroFsFileSystems {
    private static final Runnable DO_NOTHING = new Runnable(){

        @Override
        public void run() {
        }
    };

    private ZeroFsFileSystems() {
    }

    private static Runnable removeFileSystemRunnable(URI uri) {
        if (ZeroFs.systemProvider == null) {
            return DO_NOTHING;
        }
        try {
            Method method = ZeroFs.systemProvider.getClass().getDeclaredMethod("removeFileSystemRunnable", URI.class);
            return (Runnable)method.invoke(null, uri);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException("Unable to get Runnable for removing the FileSystem from the cache when it is closed", e);
        }
    }

    public static ZeroFsFileSystem newFileSystem(ZeroFsFileSystemProvider provider, URI uri, Configuration config) throws IOException {
        PathService pathService = new PathService(config);
        FileSystemState state = new FileSystemState(config.fileTimeSource, ZeroFsFileSystems.removeFileSystemRunnable(uri));
        ZeroFsFileStore fileStore = ZeroFsFileSystems.createFileStore(config, pathService, state);
        FileSystemView defaultView = ZeroFsFileSystems.createDefaultView(config, fileStore, pathService);
        WatchServiceConfiguration watchServiceConfig = config.watchServiceConfig;
        ZeroFsFileSystem fileSystem = new ZeroFsFileSystem(provider, uri, fileStore, pathService, defaultView, watchServiceConfig);
        pathService.setFileSystem(fileSystem);
        return fileSystem;
    }

    private static ZeroFsFileStore createFileStore(Configuration config, PathService pathService, FileSystemState state) {
        AttributeService attributeService = new AttributeService(config);
        HeapDisk disk = new HeapDisk(config);
        FileFactory fileFactory = new FileFactory(disk, config.fileTimeSource);
        HashMap<Name, Directory> roots = new HashMap<Name, Directory>();
        for (String root : config.roots) {
            ZeroFsPath path = pathService.parsePath(root, new String[0]);
            if (!path.isAbsolute() && path.getNameCount() == 0) {
                throw new IllegalArgumentException("Invalid root path: " + root);
            }
            Name rootName = path.root();
            Directory rootDir = fileFactory.createRootDirectory(rootName);
            attributeService.setInitialAttributes(rootDir, new FileAttribute[0]);
            roots.put(rootName, rootDir);
        }
        return new ZeroFsFileStore(new FileTree(roots), fileFactory, disk, attributeService, config.supportedFeatures, state);
    }

    private static FileSystemView createDefaultView(Configuration config, ZeroFsFileStore fileStore, PathService pathService) throws IOException {
        ZeroFsPath workingDirPath = pathService.parsePath(config.workingDirectory, new String[0]);
        Directory dir = fileStore.getRoot(workingDirPath.root());
        if (dir == null) {
            throw new IllegalArgumentException("Invalid working dir path: " + String.valueOf(workingDirPath));
        }
        for (Name name : workingDirPath.names()) {
            Directory newDir = fileStore.directoryCreator().get();
            fileStore.setInitialAttributes(newDir, new FileAttribute[0]);
            dir.link(name, newDir);
            dir = newDir;
        }
        return new FileSystemView(fileStore, dir, workingDirPath);
    }
}

