/*
 * Decompiled with CFR 0.152.
 */
package io.roastedroot.zerofs;

import io.roastedroot.zerofs.FileSystemState;
import io.roastedroot.zerofs.RegularFile;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;

final class ZeroFsInputStream
extends InputStream {
    RegularFile file;
    private long pos;
    private boolean finished;
    private final FileSystemState fileSystemState;

    public ZeroFsInputStream(RegularFile file, FileSystemState fileSystemState) {
        this.file = Objects.requireNonNull(file);
        this.fileSystemState = fileSystemState;
        fileSystemState.register(this);
    }

    @Override
    public synchronized int read() throws IOException {
        this.checkNotClosed();
        if (this.finished) {
            return -1;
        }
        this.file.readLock().lock();
        try {
            int b = this.file.read(this.pos++);
            if (b == -1) {
                this.finished = true;
            } else {
                this.file.setLastAccessTime(this.fileSystemState.now());
            }
            int n = b;
            return n;
        }
        finally {
            this.file.readLock().unlock();
        }
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.readInternal(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (off < 0 || off + len < off || off + len > b.length) {
            throw new IndexOutOfBoundsException("bad position");
        }
        return this.readInternal(b, off, len);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized int readInternal(byte[] b, int off, int len) throws IOException {
        this.checkNotClosed();
        if (this.finished) {
            return -1;
        }
        this.file.readLock().lock();
        try {
            int read = this.file.read(this.pos, b, off, len);
            if (read == -1) {
                this.finished = true;
            } else {
                this.pos += (long)read;
            }
            this.file.setLastAccessTime(this.fileSystemState.now());
            int n = read;
            return n;
        }
        finally {
            this.file.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long skip(long n) throws IOException {
        if (n <= 0L) {
            return 0L;
        }
        ZeroFsInputStream zeroFsInputStream = this;
        synchronized (zeroFsInputStream) {
            this.checkNotClosed();
            if (this.finished) {
                return 0L;
            }
            int skip = (int)Math.min(Math.max(this.file.size() - this.pos, 0L), n);
            this.pos += (long)skip;
            return skip;
        }
    }

    private static int saturatedCast(long value) {
        if (value > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        if (value < Integer.MIN_VALUE) {
            return Integer.MIN_VALUE;
        }
        return (int)value;
    }

    @Override
    public synchronized int available() throws IOException {
        this.checkNotClosed();
        if (this.finished) {
            return 0;
        }
        long available = Math.max(this.file.size() - this.pos, 0L);
        return ZeroFsInputStream.saturatedCast(available);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkNotClosed() throws IOException {
        ZeroFsInputStream zeroFsInputStream = this;
        synchronized (zeroFsInputStream) {
            if (this.file == null) {
                throw new IOException("stream is closed");
            }
        }
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.isOpen()) {
            this.fileSystemState.unregister(this);
            this.file.closed();
            this.file = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isOpen() {
        ZeroFsInputStream zeroFsInputStream = this;
        synchronized (zeroFsInputStream) {
            return this.file != null;
        }
    }
}

