/*
 * Decompiled with CFR 0.152.
 */
package io.roastedroot.zerofs;

import io.roastedroot.zerofs.FileSystemState;
import io.roastedroot.zerofs.RegularFile;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Objects;

final class ZeroFsOutputStream
extends OutputStream {
    RegularFile file;
    private long pos;
    private final boolean append;
    private final FileSystemState fileSystemState;

    ZeroFsOutputStream(RegularFile file, boolean append, FileSystemState fileSystemState) {
        this.file = Objects.requireNonNull(file);
        this.append = append;
        this.fileSystemState = fileSystemState;
        fileSystemState.register(this);
    }

    @Override
    public synchronized void write(int b) throws IOException {
        this.checkNotClosed();
        this.file.writeLock().lock();
        try {
            if (this.append) {
                this.pos = this.file.sizeWithoutLocking();
            }
            this.file.write(this.pos++, (byte)b);
            this.file.setLastModifiedTime(this.fileSystemState.now());
        }
        finally {
            this.file.writeLock().unlock();
        }
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.writeInternal(b, 0, b.length);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (off < 0 || off + len < off || off + len > b.length) {
            throw new IndexOutOfBoundsException("bad position");
        }
        this.writeInternal(b, off, len);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void writeInternal(byte[] b, int off, int len) throws IOException {
        this.checkNotClosed();
        this.file.writeLock().lock();
        try {
            if (this.append) {
                this.pos = this.file.sizeWithoutLocking();
            }
            this.pos += (long)this.file.write(this.pos, b, off, len);
            this.file.setLastModifiedTime(this.fileSystemState.now());
        }
        finally {
            this.file.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkNotClosed() throws IOException {
        ZeroFsOutputStream zeroFsOutputStream = this;
        synchronized (zeroFsOutputStream) {
            if (this.file == null) {
                throw new IOException("stream is closed");
            }
        }
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.isOpen()) {
            this.fileSystemState.unregister(this);
            this.file.closed();
            this.file = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isOpen() {
        ZeroFsOutputStream zeroFsOutputStream = this;
        synchronized (zeroFsOutputStream) {
            return this.file != null;
        }
    }
}

