/*
 * Decompiled with CFR 0.152.
 */
package io.roastedroot.zerofs;

import io.roastedroot.zerofs.AbstractWatchService;
import io.roastedroot.zerofs.Name;
import io.roastedroot.zerofs.Options;
import io.roastedroot.zerofs.PathService;
import io.roastedroot.zerofs.ZeroFsFileSystem;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.file.FileSystem;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.ProviderMismatchException;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.AbstractList;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;

final class ZeroFsPath
implements Path {
    private final Name root;
    private final List<Name> names;
    private final PathService pathService;

    public ZeroFsPath(PathService pathService, Name root, Name ... names) {
        this(pathService, root, List.of(names));
    }

    public ZeroFsPath(PathService pathService, Name root, List<Name> names) {
        this.pathService = Objects.requireNonNull(pathService);
        this.root = root;
        this.names = names;
    }

    public Name root() {
        return this.root;
    }

    public List<Name> names() {
        return this.names;
    }

    public Name name() {
        if (!this.names.isEmpty()) {
            return this.names.get(this.names.size() - 1);
        }
        return this.root;
    }

    public boolean isEmptyPath() {
        return this.root == null && this.names.size() == 1 && this.names.get(0).toString().isEmpty();
    }

    @Override
    public FileSystem getFileSystem() {
        return this.pathService.getFileSystem();
    }

    public ZeroFsFileSystem getZeroFsFileSystem() {
        return (ZeroFsFileSystem)this.pathService.getFileSystem();
    }

    @Override
    public boolean isAbsolute() {
        return this.root != null;
    }

    @Override
    public ZeroFsPath getRoot() {
        if (this.root == null) {
            return null;
        }
        return this.pathService.createRoot(this.root);
    }

    @Override
    public ZeroFsPath getFileName() {
        return this.names.isEmpty() ? null : this.getName(this.names.size() - 1);
    }

    @Override
    public ZeroFsPath getParent() {
        if (this.names.isEmpty() || this.names.size() == 1 && this.root == null) {
            return null;
        }
        return this.pathService.createPath(this.root, this.names.subList(0, this.names.size() - 1));
    }

    @Override
    public int getNameCount() {
        return this.names.size();
    }

    @Override
    public ZeroFsPath getName(int index) {
        if (index < 0 || index >= this.names.size()) {
            throw new IllegalArgumentException(String.format("index (%s) must be >= 0 and < name count (%s)", index, this.names.size()));
        }
        return this.pathService.createFileName(this.names.get(index));
    }

    @Override
    public ZeroFsPath subpath(int beginIndex, int endIndex) {
        if (beginIndex < 0 || endIndex > this.names.size() || endIndex <= beginIndex) {
            throw new IllegalArgumentException(String.format("beginIndex (%s) must be >= 0; endIndex (%s) must be <= name count (%s) and > beginIndex", beginIndex, endIndex, this.names.size()));
        }
        return this.pathService.createRelativePath(this.names.subList(beginIndex, endIndex));
    }

    private static boolean startsWith(List<?> list, List<?> other) {
        return list.size() >= other.size() && list.subList(0, other.size()).equals(other);
    }

    @Override
    public boolean startsWith(Path other) {
        ZeroFsPath otherPath = this.checkPath(other);
        return otherPath != null && this.getFileSystem().equals(otherPath.getFileSystem()) && Objects.equals(this.root, otherPath.root) && ZeroFsPath.startsWith(this.names, otherPath.names);
    }

    @Override
    public boolean startsWith(String other) {
        return this.startsWith(this.pathService.parsePath(other, new String[0]));
    }

    @Override
    public boolean endsWith(Path other) {
        ZeroFsPath otherPath = this.checkPath(other);
        if (otherPath == null) {
            return false;
        }
        if (otherPath.isAbsolute()) {
            return this.compareTo(otherPath) == 0;
        }
        ArrayList<Name> names1 = new ArrayList<Name>();
        names1.addAll(this.names);
        Collections.reverse(names1);
        ArrayList<Name> names2 = new ArrayList<Name>();
        names2.addAll(otherPath.names);
        Collections.reverse(names2);
        return ZeroFsPath.startsWith(names1, names2);
    }

    @Override
    public boolean endsWith(String other) {
        return this.endsWith(this.pathService.parsePath(other, new String[0]));
    }

    @Override
    public ZeroFsPath normalize() {
        if (this.isNormal()) {
            return this;
        }
        ArrayDeque<Name> newNames = new ArrayDeque<Name>();
        for (Name name : this.names) {
            if (name.equals(Name.PARENT)) {
                Name lastName = (Name)newNames.peekLast();
                if (lastName != null && !lastName.equals(Name.PARENT)) {
                    newNames.removeLast();
                    continue;
                }
                if (this.isAbsolute()) continue;
                newNames.add(name);
                continue;
            }
            if (name.equals(Name.SELF)) continue;
            newNames.add(name);
        }
        ArrayList<Name> comparable1 = new ArrayList<Name>();
        comparable1.addAll(newNames);
        ArrayList<Name> comparable2 = new ArrayList<Name>();
        comparable2.addAll(this.names);
        return comparable1.equals(comparable2) ? this : this.pathService.createPath(this.root, newNames);
    }

    private boolean isNormal() {
        if (this.getNameCount() == 0 || this.getNameCount() == 1 && !this.isAbsolute()) {
            return true;
        }
        boolean foundNonParentName = this.isAbsolute();
        boolean normal = true;
        for (Name name : this.names) {
            if (name.equals(Name.PARENT)) {
                if (!foundNonParentName) continue;
                normal = false;
                break;
            }
            if (name.equals(Name.SELF)) {
                normal = false;
                break;
            }
            foundNonParentName = true;
        }
        return normal;
    }

    ZeroFsPath resolve(Name name) {
        return this.resolve(this.pathService.createFileName(name));
    }

    @Override
    public ZeroFsPath resolve(Path other) {
        ZeroFsPath otherPath = this.checkPath(other);
        if (otherPath == null) {
            throw new ProviderMismatchException(other.toString());
        }
        if (this.isEmptyPath() || otherPath.isAbsolute()) {
            return otherPath;
        }
        if (otherPath.isEmptyPath()) {
            return this;
        }
        ArrayList<Name> allNames = new ArrayList<Name>();
        allNames.addAll(this.names);
        allNames.addAll(otherPath.names);
        return this.pathService.createPath(this.root, allNames);
    }

    @Override
    public ZeroFsPath resolve(String other) {
        return this.resolve(this.pathService.parsePath(other, new String[0]));
    }

    @Override
    public ZeroFsPath resolveSibling(Path other) {
        ZeroFsPath otherPath = this.checkPath(other);
        if (otherPath == null) {
            throw new ProviderMismatchException(other.toString());
        }
        if (otherPath.isAbsolute()) {
            return otherPath;
        }
        ZeroFsPath parent = this.getParent();
        if (parent == null) {
            return otherPath;
        }
        return parent.resolve(other);
    }

    @Override
    public ZeroFsPath resolveSibling(String other) {
        return this.resolveSibling(this.pathService.parsePath(other, new String[0]));
    }

    @Override
    public ZeroFsPath relativize(Path other) {
        ZeroFsPath otherPath = this.checkPath(other);
        if (otherPath == null) {
            throw new ProviderMismatchException(other.toString());
        }
        if (!Objects.equals(this.root, otherPath.root)) {
            throw new IllegalArgumentException(String.format("Paths have different roots: %s, %s", this, other));
        }
        if (this.equals(other)) {
            return this.pathService.emptyPath();
        }
        if (this.isEmptyPath()) {
            return otherPath;
        }
        List<Name> otherNames = otherPath.names;
        int sharedSubsequenceLength = 0;
        for (int i = 0; i < Math.min(this.getNameCount(), otherNames.size()) && this.names.get(i).equals(otherNames.get(i)); ++i) {
            ++sharedSubsequenceLength;
        }
        int extraNamesInThis = Math.max(0, this.getNameCount() - sharedSubsequenceLength);
        List extraNamesInOther = otherNames.size() <= sharedSubsequenceLength ? List.of() : otherNames.subList(sharedSubsequenceLength, otherNames.size());
        ArrayList<Name> parts = new ArrayList<Name>(extraNamesInThis + extraNamesInOther.size());
        parts.addAll(Collections.nCopies(extraNamesInThis, Name.PARENT));
        parts.addAll(extraNamesInOther);
        return this.pathService.createRelativePath(parts);
    }

    @Override
    public ZeroFsPath toAbsolutePath() {
        return this.isAbsolute() ? this : this.getZeroFsFileSystem().getWorkingDirectory().resolve(this);
    }

    @Override
    public ZeroFsPath toRealPath(LinkOption ... options) throws IOException {
        return this.getZeroFsFileSystem().getDefaultView().toRealPath(this, this.pathService, Options.getLinkOptions(options));
    }

    @Override
    public WatchKey register(WatchService watcher, WatchEvent.Kind<?>[] events, WatchEvent.Modifier ... modifiers) throws IOException {
        Objects.requireNonNull(modifiers);
        return this.register(watcher, events);
    }

    @Override
    public WatchKey register(WatchService watcher, WatchEvent.Kind<?> ... events) throws IOException {
        Objects.requireNonNull(watcher);
        Objects.requireNonNull(events);
        if (!(watcher instanceof AbstractWatchService)) {
            throw new IllegalArgumentException("watcher (" + String.valueOf(watcher) + ") is not associated with this file system");
        }
        AbstractWatchService service = (AbstractWatchService)watcher;
        return service.register(this, Arrays.asList(events));
    }

    @Override
    public URI toUri() {
        return this.getZeroFsFileSystem().toUri(this);
    }

    @Override
    public File toFile() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterator<Path> iterator() {
        return this.asList().iterator();
    }

    private List<Path> asList() {
        return new AbstractList<Path>(){

            @Override
            public Path get(int index) {
                return ZeroFsPath.this.getName(index);
            }

            @Override
            public int size() {
                return ZeroFsPath.this.getNameCount();
            }
        };
    }

    @Override
    public int compareTo(Path other) {
        ZeroFsPath otherPath = (ZeroFsPath)other;
        Comparator<ZeroFsPath> comparator = Comparator.comparing(p -> p.getZeroFsFileSystem().getUri()).thenComparing(this.pathService);
        return comparator.compare(this, otherPath);
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof ZeroFsPath && this.compareTo((ZeroFsPath)obj) == 0;
    }

    @Override
    public int hashCode() {
        return this.pathService.hash(this);
    }

    @Override
    public String toString() {
        return this.pathService.toString(this);
    }

    private ZeroFsPath checkPath(Path other) {
        if (Objects.requireNonNull(other) instanceof ZeroFsPath && other.getFileSystem().equals(this.getFileSystem())) {
            return (ZeroFsPath)other;
        }
        return null;
    }
}

