/*
 * Decompiled with CFR 0.152.
 */
package io.roastedroot.zerofs;

import io.roastedroot.zerofs.Directory;
import io.roastedroot.zerofs.File;
import io.roastedroot.zerofs.Name;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.NoSuchFileException;
import java.nio.file.NotDirectoryException;
import java.nio.file.NotLinkException;
import java.nio.file.Path;
import java.util.Objects;

final class DirectoryEntry {
    private final Directory directory;
    private final Name name;
    private final File file;
    DirectoryEntry next;

    DirectoryEntry(Directory directory, Name name, File file) {
        this.directory = Objects.requireNonNull(directory);
        this.name = Objects.requireNonNull(name);
        this.file = file;
    }

    public boolean exists() {
        return this.file != null;
    }

    public DirectoryEntry requireExists(Path pathForException) throws NoSuchFileException {
        if (!this.exists()) {
            throw new NoSuchFileException(pathForException.toString());
        }
        return this;
    }

    public DirectoryEntry requireDoesNotExist(Path pathForException) throws FileAlreadyExistsException {
        if (this.exists()) {
            throw new FileAlreadyExistsException(pathForException.toString());
        }
        return this;
    }

    public DirectoryEntry requireDirectory(Path pathForException) throws NoSuchFileException, NotDirectoryException {
        this.requireExists(pathForException);
        if (!this.file().isDirectory()) {
            throw new NotDirectoryException(pathForException.toString());
        }
        return this;
    }

    public DirectoryEntry requireSymbolicLink(Path pathForException) throws NoSuchFileException, NotLinkException {
        this.requireExists(pathForException);
        if (!this.file().isSymbolicLink()) {
            throw new NotLinkException(pathForException.toString());
        }
        return this;
    }

    public Directory directory() {
        return this.directory;
    }

    public Name name() {
        return this.name;
    }

    public File file() {
        if (!this.exists()) {
            throw new IllegalStateException("file doesn't exists");
        }
        return this.file;
    }

    public File fileOrNull() {
        return this.file;
    }

    public boolean equals(Object obj) {
        if (obj instanceof DirectoryEntry) {
            DirectoryEntry other = (DirectoryEntry)obj;
            return this.directory.equals(other.directory) && this.name.equals(other.name) && Objects.equals(this.file, other.file);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.directory, this.name, this.file);
    }

    public String toString() {
        return "DirectoryEntry{directory=" + String.valueOf(this.directory) + ", name=" + String.valueOf(this.name) + ", file=" + String.valueOf(this.file) + "}";
    }
}

