/*
 * Decompiled with CFR 0.152.
 */
package io.roastedroot.zerofs;

import io.roastedroot.zerofs.Directory;
import io.roastedroot.zerofs.DirectoryEntry;
import io.roastedroot.zerofs.RegularFile;
import io.roastedroot.zerofs.SymbolicLink;
import java.io.IOException;
import java.nio.file.attribute.FileTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.locks.ReadWriteLock;

public abstract class File {
    private final int id;
    private int links;
    private FileTime creationTime;
    private FileTime lastAccessTime;
    private FileTime lastModifiedTime;
    private Map<String, Map<String, Object>> attributes;

    File(int id, FileTime creationTime) {
        this.id = id;
        this.creationTime = creationTime;
        this.lastAccessTime = creationTime;
        this.lastModifiedTime = creationTime;
    }

    public int id() {
        return this.id;
    }

    public long size() {
        return 0L;
    }

    public final boolean isDirectory() {
        return this instanceof Directory;
    }

    public final boolean isRegularFile() {
        return this instanceof RegularFile;
    }

    public final boolean isSymbolicLink() {
        return this instanceof SymbolicLink;
    }

    abstract File copyWithoutContent(int var1, FileTime var2);

    void copyContentTo(File file) throws IOException {
    }

    ReadWriteLock contentLock() {
        return null;
    }

    void opened() {
    }

    void closed() {
    }

    void deleted() {
    }

    final boolean isRootDirectory() {
        return this.isDirectory() && this.equals(((Directory)this).parent());
    }

    public final synchronized int links() {
        return this.links;
    }

    void linked(DirectoryEntry entry) {
        Objects.requireNonNull(entry);
    }

    void unlinked() {
    }

    final synchronized void incrementLinkCount() {
        ++this.links;
    }

    final synchronized void decrementLinkCount() {
        --this.links;
    }

    public final synchronized FileTime getCreationTime() {
        return this.creationTime;
    }

    public final synchronized FileTime getLastAccessTime() {
        return this.lastAccessTime;
    }

    public final synchronized FileTime getLastModifiedTime() {
        return this.lastModifiedTime;
    }

    final synchronized void setCreationTime(FileTime creationTime) {
        this.creationTime = creationTime;
    }

    final synchronized void setLastAccessTime(FileTime lastAccessTime) {
        this.lastAccessTime = lastAccessTime;
    }

    final synchronized void setLastModifiedTime(FileTime lastModifiedTime) {
        this.lastModifiedTime = lastModifiedTime;
    }

    public final synchronized Set<String> getAttributeNames(String view) {
        if (this.attributes == null) {
            return Set.of();
        }
        Map<String, Object> row = this.attributes.get(view);
        if (row == null) {
            return null;
        }
        return Set.copyOf(row.keySet());
    }

    final synchronized Set<String> getAttributeKeys() {
        if (this.attributes == null) {
            return Set.of();
        }
        TreeSet<String> builder = new TreeSet<String>();
        for (Map.Entry<String, Map<String, Object>> row : this.attributes.entrySet()) {
            for (Map.Entry<String, Object> col : row.getValue().entrySet()) {
                builder.add(row.getKey() + ":" + col.getKey());
            }
        }
        return builder;
    }

    public final synchronized Object getAttribute(String view, String attribute) {
        if (this.attributes == null) {
            return null;
        }
        Map<String, Object> existing = this.attributes.get(view);
        if (existing == null) {
            return null;
        }
        return existing.get(attribute);
    }

    public final synchronized void setAttribute(String view, String attribute, Object value) {
        if (this.attributes == null) {
            this.attributes = new HashMap<String, Map<String, Object>>();
        }
        if (this.attributes.containsKey(view)) {
            Map<String, Object> existing = this.attributes.get(view);
            existing.put(attribute, value);
        } else {
            HashMap<String, Object> val = new HashMap<String, Object>();
            val.put(attribute, value);
            this.attributes.put(view, val);
        }
    }

    public final synchronized void deleteAttribute(String view, String attribute) {
        if (this.attributes != null) {
            this.attributes.get(view).remove(attribute);
        }
    }

    final synchronized void copyBasicAttributes(File target) {
        target.setFileTimes(this.creationTime, this.lastModifiedTime, this.lastAccessTime);
    }

    private synchronized void setFileTimes(FileTime creationTime, FileTime lastModifiedTime, FileTime lastAccessTime) {
        this.creationTime = creationTime;
        this.lastModifiedTime = lastModifiedTime;
        this.lastAccessTime = lastAccessTime;
    }

    final synchronized void copyAttributes(File target) {
        this.copyBasicAttributes(target);
        target.putAll(this.attributes);
    }

    private synchronized void putAll(Map<String, Map<String, Object>> attributes) {
        if (attributes != null && this.attributes != attributes) {
            if (this.attributes == null) {
                this.attributes = new HashMap<String, Map<String, Object>>();
            }
            this.attributes.putAll(attributes);
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{id=" + this.id + "}";
    }
}

