/*
 * Decompiled with CFR 0.152.
 */
package io.roastedroot.zerofs;

import java.nio.file.CopyOption;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

final class Options {
    public static final Set<LinkOption> NOFOLLOW_LINKS = Set.of(LinkOption.NOFOLLOW_LINKS);
    public static final Set<LinkOption> FOLLOW_LINKS = Set.of();
    private static final Set<OpenOption> DEFAULT_READ = Set.of(StandardOpenOption.READ);
    private static final Set<OpenOption> DEFAULT_READ_NOFOLLOW_LINKS = Set.of(StandardOpenOption.READ, LinkOption.NOFOLLOW_LINKS);
    private static final Set<OpenOption> DEFAULT_WRITE = Set.of(StandardOpenOption.WRITE, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);

    private Options() {
    }

    public static Set<LinkOption> getLinkOptions(LinkOption ... options) {
        return options.length == 0 ? FOLLOW_LINKS : NOFOLLOW_LINKS;
    }

    public static Set<OpenOption> getOptionsForChannel(Set<? extends OpenOption> options) {
        boolean read;
        if (options.isEmpty()) {
            return DEFAULT_READ;
        }
        boolean append = options.contains(StandardOpenOption.APPEND);
        boolean write = append || options.contains(StandardOpenOption.WRITE);
        boolean bl = read = !write || options.contains(StandardOpenOption.READ);
        if (read) {
            if (append) {
                throw new UnsupportedOperationException("'READ' + 'APPEND' not allowed");
            }
            if (!write) {
                return options.stream().anyMatch(o -> o.hashCode() == LinkOption.NOFOLLOW_LINKS.hashCode()) ? DEFAULT_READ_NOFOLLOW_LINKS : DEFAULT_READ;
            }
        }
        return Options.addWrite(options);
    }

    public static Set<OpenOption> getOptionsForInputStream(OpenOption ... options) {
        boolean nofollowLinks = false;
        for (OpenOption option : options) {
            if (Objects.requireNonNull(option) == StandardOpenOption.READ) continue;
            if (option == LinkOption.NOFOLLOW_LINKS) {
                nofollowLinks = true;
                continue;
            }
            throw new UnsupportedOperationException("'" + String.valueOf(option) + "' not allowed");
        }
        return nofollowLinks ? NOFOLLOW_LINKS : FOLLOW_LINKS;
    }

    public static Set<OpenOption> getOptionsForOutputStream(OpenOption ... options) {
        if (options.length == 0) {
            return DEFAULT_WRITE;
        }
        Set<OpenOption> result = Options.addWrite(Arrays.asList(options));
        if (result.contains(StandardOpenOption.READ)) {
            throw new UnsupportedOperationException("'READ' not allowed");
        }
        return result;
    }

    private static Set<OpenOption> addWrite(Collection<? extends OpenOption> options) {
        if (options.contains(StandardOpenOption.WRITE)) {
            return Set.copyOf(options);
        }
        HashSet<OpenOption> opts = new HashSet<OpenOption>();
        opts.add(StandardOpenOption.WRITE);
        opts.addAll(options);
        return opts;
    }

    public static Set<CopyOption> getMoveOptions(CopyOption ... options) {
        ArrayList<CopyOption> opts = new ArrayList<CopyOption>();
        opts.add(LinkOption.NOFOLLOW_LINKS);
        opts.addAll(List.of(options));
        return Set.copyOf(opts);
    }

    public static Set<CopyOption> getCopyOptions(CopyOption ... options) {
        Set<CopyOption> result = Set.copyOf(List.of(options));
        if (result.contains(StandardCopyOption.ATOMIC_MOVE)) {
            throw new UnsupportedOperationException("'ATOMIC_MOVE' not allowed");
        }
        return result;
    }
}

