/*
 * Decompiled with CFR 0.152.
 */
package io.roastedroot.zerofs;

import io.roastedroot.zerofs.AbstractAttributeView;
import io.roastedroot.zerofs.AttributeProvider;
import io.roastedroot.zerofs.File;
import io.roastedroot.zerofs.FileLookup;
import io.roastedroot.zerofs.UserLookupService;
import java.io.IOException;
import java.nio.file.attribute.FileAttributeView;
import java.nio.file.attribute.FileOwnerAttributeView;
import java.nio.file.attribute.UserPrincipal;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

final class OwnerAttributeProvider
extends AttributeProvider {
    private static final Set<String> ATTRIBUTES = Set.of("owner");
    private static final UserPrincipal DEFAULT_OWNER = UserLookupService.createUserPrincipal("user");

    OwnerAttributeProvider() {
    }

    @Override
    public String name() {
        return "owner";
    }

    @Override
    public Set<String> fixedAttributes() {
        return ATTRIBUTES;
    }

    @Override
    public Map<String, ?> defaultValues(Map<String, ?> userProvidedDefaults) {
        Object userProvidedOwner = userProvidedDefaults.get("owner:owner");
        UserPrincipal owner = DEFAULT_OWNER;
        if (userProvidedOwner != null) {
            if (userProvidedOwner instanceof String) {
                owner = UserLookupService.createUserPrincipal((String)userProvidedOwner);
            } else {
                throw OwnerAttributeProvider.invalidType("owner", "owner", userProvidedOwner, String.class, UserPrincipal.class);
            }
        }
        return Map.of("owner:owner", owner);
    }

    @Override
    public Object get(File file, String attribute) {
        if (attribute.equals("owner")) {
            return file.getAttribute("owner", "owner");
        }
        return null;
    }

    @Override
    public void set(File file, String view, String attribute, Object value, boolean create) {
        if (attribute.equals("owner")) {
            OwnerAttributeProvider.checkNotCreate(view, attribute, create);
            UserPrincipal user = OwnerAttributeProvider.checkType(view, attribute, value, UserPrincipal.class);
            if (!(user instanceof UserLookupService.ZeroFsUserPrincipal)) {
                user = UserLookupService.createUserPrincipal(user.getName());
            }
            file.setAttribute("owner", "owner", user);
        }
    }

    public Class<FileOwnerAttributeView> viewType() {
        return FileOwnerAttributeView.class;
    }

    @Override
    public FileOwnerAttributeView view(FileLookup lookup, Map<String, FileAttributeView> inheritedViews) {
        return new View(lookup);
    }

    private static final class View
    extends AbstractAttributeView
    implements FileOwnerAttributeView {
        public View(FileLookup lookup) {
            super(lookup);
        }

        @Override
        public String name() {
            return "owner";
        }

        @Override
        public UserPrincipal getOwner() throws IOException {
            return (UserPrincipal)this.lookupFile().getAttribute("owner", "owner");
        }

        @Override
        public void setOwner(UserPrincipal owner) throws IOException {
            this.lookupFile().setAttribute("owner", "owner", Objects.requireNonNull(owner));
        }
    }
}

