/*
 * Decompiled with CFR 0.152.
 */
package io.roastedroot.zerofs;

import io.roastedroot.zerofs.GlobToRegex;
import io.roastedroot.zerofs.PathNormalization;
import io.roastedroot.zerofs.Util;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;

final class PathMatchers {
    private PathMatchers() {
    }

    public static PathMatcher getPathMatcher(String syntaxAndPattern, String separators, Set<PathNormalization> normalizations) {
        int syntaxSeparator = syntaxAndPattern.indexOf(58);
        if (syntaxSeparator <= 0) {
            throw new IllegalArgumentException(String.format("Must be of the form 'syntax:pattern': %s", syntaxAndPattern));
        }
        String syntax = Util.toLowerCase(syntaxAndPattern.substring(0, syntaxSeparator));
        String pattern = syntaxAndPattern.substring(syntaxSeparator + 1);
        switch (syntax) {
            case "glob": {
                pattern = GlobToRegex.toRegex(pattern, separators);
            }
            case "regex": {
                return PathMatchers.fromRegex(pattern, normalizations);
            }
        }
        throw new UnsupportedOperationException("Invalid syntax: " + syntaxAndPattern);
    }

    private static PathMatcher fromRegex(String regex, Iterable<PathNormalization> normalizations) {
        return new RegexPathMatcher(PathNormalization.compilePattern(regex, normalizations));
    }

    static final class RegexPathMatcher
    implements PathMatcher {
        private final Pattern pattern;

        private RegexPathMatcher(Pattern pattern) {
            this.pattern = Objects.requireNonNull(pattern);
        }

        @Override
        public boolean matches(Path path) {
            return this.pattern.matcher(path.toString()).matches();
        }

        public String toString() {
            return "RegexPathMatcher{pattern=" + String.valueOf(this.pattern) + "}";
        }
    }
}

