/*
 * Decompiled with CFR 0.152.
 */
package io.roastedroot.zerofs;

import io.roastedroot.zerofs.Util;
import java.text.Normalizer;
import java.util.Locale;
import java.util.function.Function;
import java.util.regex.Pattern;

public enum PathNormalization implements Function<String, String>
{
    NONE(0){

        @Override
        public String apply(String string) {
            return string;
        }
    }
    ,
    NFC(128){

        @Override
        public String apply(String string) {
            return Normalizer.normalize(string, Normalizer.Form.NFC);
        }
    }
    ,
    NFD(128){

        @Override
        public String apply(String string) {
            return Normalizer.normalize(string, Normalizer.Form.NFD);
        }
    }
    ,
    CASE_FOLD_UNICODE(66){

        @Override
        public String apply(String string) {
            return string.toLowerCase(Locale.ROOT);
        }
    }
    ,
    CASE_FOLD_ASCII(2){

        @Override
        public String apply(String string) {
            return Util.toLowerCase(string);
        }
    };

    private final int patternFlags;

    private PathNormalization(int patternFlags) {
        this.patternFlags = patternFlags;
    }

    @Override
    public abstract String apply(String var1);

    public int patternFlags() {
        return this.patternFlags;
    }

    public static String normalize(String string, Iterable<PathNormalization> normalizations) {
        String result = string;
        for (PathNormalization normalization : normalizations) {
            result = normalization.apply(result);
        }
        return result;
    }

    public static Pattern compilePattern(String regex, Iterable<PathNormalization> normalizations) {
        int flags = 0;
        for (PathNormalization normalization : normalizations) {
            flags |= normalization.patternFlags();
        }
        return Pattern.compile(regex, flags);
    }
}

