/*
 * Decompiled with CFR 0.152.
 */
package io.roastedroot.zerofs;

import io.roastedroot.zerofs.Configuration;
import io.roastedroot.zerofs.LexicographicalOrdering;
import io.roastedroot.zerofs.Name;
import io.roastedroot.zerofs.PathMatchers;
import io.roastedroot.zerofs.PathNormalization;
import io.roastedroot.zerofs.PathType;
import io.roastedroot.zerofs.Util;
import io.roastedroot.zerofs.ZeroFsPath;
import java.net.URI;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.PathMatcher;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Predicate;

final class PathService
implements Comparator<ZeroFsPath> {
    private static final Comparator<Name> DISPLAY_ROOT_COMPARATOR = Comparator.nullsLast(Name.displayComparator());
    private static final Comparator<Iterable<Name>> DISPLAY_NAMES_COMPARATOR = new LexicographicalOrdering<Name>(Name.displayComparator());
    private static final Comparator<Name> CANONICAL_ROOT_COMPARATOR = Comparator.nullsLast(Name.canonicalComparator());
    private static final Comparator<Iterable<Name>> CANONICAL_NAMES_COMPARATOR = new LexicographicalOrdering<Name>(Name.canonicalComparator());
    private final PathType type;
    private final Set<PathNormalization> displayNormalizations;
    private final Set<PathNormalization> canonicalNormalizations;
    private final boolean equalityUsesCanonicalForm;
    private final Comparator<Name> rootComparator;
    private final Comparator<Iterable<Name>> namesComparator;
    private volatile FileSystem fileSystem;
    private volatile ZeroFsPath emptyPath;
    private static final Predicate<Object> NOT_EMPTY = input -> !input.toString().isEmpty();

    PathService(Configuration config) {
        this(config.pathType, config.nameDisplayNormalization, config.nameCanonicalNormalization, config.pathEqualityUsesCanonicalForm);
    }

    PathService(PathType type, Iterable<PathNormalization> displayNormalizations, Iterable<PathNormalization> canonicalNormalizations, boolean equalityUsesCanonicalForm) {
        this.type = Objects.requireNonNull(type);
        this.displayNormalizations = new TreeSet<PathNormalization>();
        Iterator<PathNormalization> displayNormalizationsIter = displayNormalizations.iterator();
        while (displayNormalizationsIter.hasNext()) {
            this.displayNormalizations.add(displayNormalizationsIter.next());
        }
        this.canonicalNormalizations = new TreeSet<PathNormalization>();
        Iterator<PathNormalization> canonicalNormalizationsIter = canonicalNormalizations.iterator();
        while (canonicalNormalizationsIter.hasNext()) {
            this.canonicalNormalizations.add(canonicalNormalizationsIter.next());
        }
        this.equalityUsesCanonicalForm = equalityUsesCanonicalForm;
        this.rootComparator = equalityUsesCanonicalForm ? CANONICAL_ROOT_COMPARATOR : DISPLAY_ROOT_COMPARATOR;
        this.namesComparator = equalityUsesCanonicalForm ? CANONICAL_NAMES_COMPARATOR : DISPLAY_NAMES_COMPARATOR;
    }

    public void setFileSystem(FileSystem fileSystem) {
        if (this.fileSystem != null) {
            new IllegalStateException("may not set fileSystem twice");
        }
        this.fileSystem = Objects.requireNonNull(fileSystem);
    }

    public FileSystem getFileSystem() {
        return this.fileSystem;
    }

    public String getSeparator() {
        return this.type.getSeparator();
    }

    public ZeroFsPath emptyPath() {
        ZeroFsPath result = this.emptyPath;
        if (result == null) {
            this.emptyPath = result = this.createPathInternal(null, List.of(Name.EMPTY));
            return result;
        }
        return result;
    }

    public Name name(String name) {
        switch (name) {
            case "": {
                return Name.EMPTY;
            }
            case ".": {
                return Name.SELF;
            }
            case "..": {
                return Name.PARENT;
            }
        }
        String display = PathNormalization.normalize(name, this.displayNormalizations);
        String canonical = PathNormalization.normalize(name, this.canonicalNormalizations);
        return Name.create(display, canonical);
    }

    List<Name> names(String[] names) {
        ArrayList<Name> result = new ArrayList<Name>();
        for (String name : names) {
            result.add(this.name(name));
        }
        return result;
    }

    public ZeroFsPath createRoot(Name root) {
        return this.createPath(Objects.requireNonNull(root), List.of());
    }

    public ZeroFsPath createFileName(Name name) {
        return this.createPath(null, List.of(name));
    }

    public ZeroFsPath createRelativePath(Iterable<Name> names) {
        ArrayList<Name> allNames = new ArrayList<Name>();
        Iterator<Name> namesIter = names.iterator();
        while (namesIter.hasNext()) {
            allNames.add(namesIter.next());
        }
        return this.createPath(null, allNames);
    }

    public ZeroFsPath createPath(Name root, Iterable<Name> names) {
        ArrayList<Name> nameList = new ArrayList<Name>();
        for (Name current : names) {
            if (!NOT_EMPTY.test(current)) continue;
            nameList.add(current);
        }
        if (root == null && nameList.isEmpty()) {
            return this.emptyPath();
        }
        return this.createPathInternal(root, nameList);
    }

    protected final ZeroFsPath createPathInternal(Name root, Iterable<Name> names) {
        ArrayList<Name> nameList = new ArrayList<Name>();
        Iterator<Name> namesIter = names.iterator();
        while (namesIter.hasNext()) {
            nameList.add(namesIter.next());
        }
        return new ZeroFsPath(this, root, (Name[])nameList.toArray(Name[]::new));
    }

    public ZeroFsPath parsePath(String first, String ... more) {
        ArrayList<String> args = new ArrayList<String>();
        if (NOT_EMPTY.test(first)) {
            args.add(first);
        }
        for (String e : more) {
            if (!NOT_EMPTY.test(e)) continue;
            args.add(e);
        }
        String joined = this.type.join((String[])args.toArray(String[]::new));
        return this.toPath(this.type.parsePath(joined));
    }

    private ZeroFsPath toPath(PathType.ParseResult parsed) {
        Name root = parsed.root() == null ? null : this.name(parsed.root());
        List<Name> names = this.names(parsed.names());
        return this.createPath(root, names);
    }

    public String toString(ZeroFsPath path) {
        Name root = path.root();
        String rootString = root == null ? null : root.toString();
        String[] names = Util.toArray(path.names());
        return this.type.toString(rootString, names);
    }

    public int hash(ZeroFsPath path) {
        int hash = 31;
        hash = 31 * hash + this.getFileSystem().hashCode();
        Name root = path.root();
        List<Name> names = path.names();
        if (this.equalityUsesCanonicalForm) {
            hash = 31 * hash + (root == null ? 0 : root.hashCode());
            for (Name name : names) {
                hash = 31 * hash + name.hashCode();
            }
        } else {
            hash = 31 * hash + (root == null ? 0 : root.toString().hashCode());
            for (Name name : names) {
                hash = 31 * hash + name.toString().hashCode();
            }
        }
        return hash;
    }

    @Override
    public int compare(ZeroFsPath a, ZeroFsPath b) {
        Comparator<ZeroFsPath> comparator = Comparator.comparing(ZeroFsPath::root, this.rootComparator).thenComparing(ZeroFsPath::names, this.namesComparator);
        return comparator.compare(a, b);
    }

    public URI toUri(URI fileSystemUri, ZeroFsPath path) {
        if (!path.isAbsolute()) {
            throw new IllegalArgumentException(String.format("path (%s) must be absolute", path));
        }
        String root = String.valueOf(path.root());
        String[] names = Util.toArray(path.names());
        return this.type.toUri(fileSystemUri, root, names, Files.isDirectory(path, LinkOption.NOFOLLOW_LINKS));
    }

    public ZeroFsPath fromUri(URI uri) {
        return this.toPath(this.type.fromUri(uri));
    }

    public PathMatcher createPathMatcher(String syntaxAndPattern) {
        return PathMatchers.getPathMatcher(syntaxAndPattern, this.type.getSeparator() + this.type.getOtherSeparators(), this.equalityUsesCanonicalForm ? this.canonicalNormalizations : this.displayNormalizations);
    }
}

