/*
 * Decompiled with CFR 0.152.
 */
package io.roastedroot.zerofs;

import io.roastedroot.zerofs.UnixPathType;
import io.roastedroot.zerofs.WindowsPathType;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public abstract class PathType {
    private final boolean allowsMultipleRoots;
    private final String separator;
    private final String otherSeparators;
    private final String splitter;
    private static final char[] regexReservedChars = "^$.?+*\\[]{}()".toCharArray();

    public static PathType unix() {
        return UnixPathType.INSTANCE;
    }

    public static PathType windows() {
        return WindowsPathType.INSTANCE;
    }

    protected PathType(boolean allowsMultipleRoots, char separator, char ... otherSeparators) {
        this.separator = String.valueOf(separator);
        this.allowsMultipleRoots = allowsMultipleRoots;
        this.otherSeparators = String.valueOf(otherSeparators);
        this.splitter = PathType.createSplitter(separator, otherSeparators);
    }

    private static String createSplitter(char separator, char ... otherSeparators) {
        if (otherSeparators.length == 0) {
            return "" + separator;
        }
        StringBuilder patternBuilder = new StringBuilder();
        patternBuilder.append("[");
        PathType.appendToRegex(separator, patternBuilder);
        for (char other : otherSeparators) {
            PathType.appendToRegex(other, patternBuilder);
        }
        patternBuilder.append("]");
        return patternBuilder.toString();
    }

    private static boolean isRegexReserved(char c) {
        return Arrays.binarySearch(regexReservedChars, c) >= 0;
    }

    private static void appendToRegex(char separator, StringBuilder patternBuilder) {
        if (PathType.isRegexReserved(separator)) {
            patternBuilder.append("\\");
        }
        patternBuilder.append(separator);
    }

    public final boolean allowsMultipleRoots() {
        return this.allowsMultipleRoots;
    }

    public final String join(String[] strs) {
        return Arrays.asList(strs).stream().collect(Collectors.joining(this.separator));
    }

    public final String[] split(String str) {
        String[] baseSplit = str.split(this.splitter);
        ArrayList<String> result = new ArrayList<String>();
        for (int i = 0; i < baseSplit.length; ++i) {
            if (baseSplit[i] == null || baseSplit[i].isEmpty()) continue;
            result.add(baseSplit[i]);
        }
        return result.toArray(new String[0]);
    }

    public final String getSeparator() {
        return this.separator;
    }

    public final String getOtherSeparators() {
        return this.otherSeparators;
    }

    protected final ParseResult emptyPath() {
        return new ParseResult(null, new String[]{""});
    }

    public abstract ParseResult parsePath(String var1);

    public String toString() {
        return this.getClass().getSimpleName();
    }

    public abstract String toString(String var1, String[] var2);

    protected abstract String toUriPath(String var1, String[] var2, boolean var3);

    protected abstract ParseResult parseUriPath(String var1);

    public final URI toUri(URI fileSystemUri, String root, List<String> names, boolean directory) {
        return this.toUri(fileSystemUri, root, (String[])names.toArray(String[]::new), directory);
    }

    public final URI toUri(URI fileSystemUri, String root, String[] names, boolean directory) {
        String path = this.toUriPath(root, names, directory);
        try {
            return new URI(fileSystemUri.getScheme(), fileSystemUri.getUserInfo(), fileSystemUri.getHost(), fileSystemUri.getPort(), path, null, null);
        }
        catch (URISyntaxException e) {
            throw new AssertionError((Object)e);
        }
    }

    public final ParseResult fromUri(URI uri) {
        return this.parseUriPath(uri.getPath());
    }

    static {
        Arrays.sort(regexReservedChars);
    }

    public static final class ParseResult {
        private final String root;
        private final String[] names;

        public ParseResult(String root, String[] names) {
            this.root = root;
            this.names = Objects.requireNonNull(names);
        }

        public boolean isAbsolute() {
            return this.root != null;
        }

        public boolean isRoot() {
            return this.root != null && (this.names == null || this.names.length == 0);
        }

        public String root() {
            return this.root;
        }

        public String[] names() {
            return this.names;
        }
    }
}

