/*
 * Decompiled with CFR 0.152.
 */
package io.roastedroot.zerofs;

import io.roastedroot.zerofs.AbstractWatchService;
import io.roastedroot.zerofs.FileSystemState;
import io.roastedroot.zerofs.FileSystemView;
import io.roastedroot.zerofs.Name;
import io.roastedroot.zerofs.PathService;
import io.roastedroot.zerofs.ZeroFsFileSystem;
import io.roastedroot.zerofs.ZeroFsPath;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.Watchable;
import java.nio.file.attribute.FileTime;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

final class PollingWatchService
extends AbstractWatchService {
    private static final ThreadFactory THREAD_FACTORY = new ZeroFsThreadFactory("io.roastedroot.zerofs.PollingWatchService-thread-%d", true);
    private final ScheduledExecutorService pollingService = Executors.newSingleThreadScheduledExecutor(THREAD_FACTORY);
    private final ConcurrentMap<AbstractWatchService.Key, Snapshot> snapshots = new ConcurrentHashMap<AbstractWatchService.Key, Snapshot>();
    private final FileSystemView view;
    private final PathService pathService;
    private final FileSystemState fileSystemState;
    final long interval;
    final TimeUnit timeUnit;
    private ScheduledFuture<?> pollingFuture;
    private final Runnable pollingTask = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            PollingWatchService pollingWatchService = PollingWatchService.this;
            synchronized (pollingWatchService) {
                for (Map.Entry entry : PollingWatchService.this.snapshots.entrySet()) {
                    AbstractWatchService.Key key = (AbstractWatchService.Key)entry.getKey();
                    Snapshot previousSnapshot = (Snapshot)entry.getValue();
                    ZeroFsPath path = (ZeroFsPath)key.watchable();
                    try {
                        Snapshot newSnapshot = PollingWatchService.this.takeSnapshot(path);
                        boolean posted = previousSnapshot.postChanges(newSnapshot, key);
                        entry.setValue(newSnapshot);
                        if (!posted) continue;
                        key.signal();
                    }
                    catch (IOException e) {
                        key.cancel();
                    }
                }
            }
        }
    };

    PollingWatchService(FileSystemView view, PathService pathService, FileSystemState fileSystemState, long interval, TimeUnit timeUnit) {
        this.view = Objects.requireNonNull(view);
        this.pathService = Objects.requireNonNull(pathService);
        this.fileSystemState = Objects.requireNonNull(fileSystemState);
        if (interval < 0L) {
            throw new IllegalArgumentException(String.format("interval (%s) may not be negative", interval));
        }
        this.interval = interval;
        this.timeUnit = Objects.requireNonNull(timeUnit);
        fileSystemState.register(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AbstractWatchService.Key register(Watchable watchable, Iterable<? extends WatchEvent.Kind<?>> eventTypes) throws IOException {
        ZeroFsPath path = this.checkWatchable(watchable);
        AbstractWatchService.Key key = super.register(path, eventTypes);
        Snapshot snapshot = this.takeSnapshot(path);
        PollingWatchService pollingWatchService = this;
        synchronized (pollingWatchService) {
            this.snapshots.put(key, snapshot);
            if (this.pollingFuture == null) {
                this.startPolling();
            }
        }
        return key;
    }

    private ZeroFsPath checkWatchable(Watchable watchable) {
        if (!(watchable instanceof ZeroFsPath) || !this.isSameFileSystem((Path)watchable)) {
            throw new IllegalArgumentException("watchable (" + String.valueOf(watchable) + ") must be a Path associated with the same file system as this watch service");
        }
        return (ZeroFsPath)watchable;
    }

    private boolean isSameFileSystem(Path path) {
        return ((ZeroFsFileSystem)path.getFileSystem()).getDefaultView() == this.view;
    }

    synchronized boolean isPolling() {
        return this.pollingFuture != null;
    }

    @Override
    public synchronized void cancelled(AbstractWatchService.Key key) {
        this.snapshots.remove(key);
        if (this.snapshots.isEmpty()) {
            this.stopPolling();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        super.close();
        PollingWatchService pollingWatchService = this;
        synchronized (pollingWatchService) {
            for (AbstractWatchService.Key key : this.snapshots.keySet()) {
                key.cancel();
            }
            this.pollingService.shutdown();
            this.fileSystemState.unregister(this);
        }
    }

    private void startPolling() {
        this.pollingFuture = this.pollingService.scheduleAtFixedRate(this.pollingTask, this.interval, this.interval, this.timeUnit);
    }

    private void stopPolling() {
        this.pollingFuture.cancel(false);
        this.pollingFuture = null;
    }

    private Snapshot takeSnapshot(ZeroFsPath path) throws IOException {
        return new Snapshot(this.view.snapshotModifiedTimes(path));
    }

    private final class Snapshot {
        private final Map<Name, FileTime> modifiedTimes;

        Snapshot(Map<Name, FileTime> modifiedTimes) {
            this.modifiedTimes = Map.copyOf(modifiedTimes);
        }

        boolean postChanges(Snapshot newState, AbstractWatchService.Key key) {
            boolean changesPosted = false;
            if (key.subscribesTo(StandardWatchEventKinds.ENTRY_CREATE)) {
                HashSet<Name> created = new HashSet<Name>(newState.modifiedTimes.keySet());
                created.removeAll(this.modifiedTimes.keySet());
                for (Name name : created) {
                    key.post(new AbstractWatchService.Event<ZeroFsPath>(StandardWatchEventKinds.ENTRY_CREATE, 1, PollingWatchService.this.pathService.createFileName(name)));
                    changesPosted = true;
                }
            }
            if (key.subscribesTo(StandardWatchEventKinds.ENTRY_DELETE)) {
                HashSet<Name> deleted = new HashSet<Name>(this.modifiedTimes.keySet());
                deleted.removeAll(newState.modifiedTimes.keySet());
                for (Name name : deleted) {
                    key.post(new AbstractWatchService.Event<ZeroFsPath>(StandardWatchEventKinds.ENTRY_DELETE, 1, PollingWatchService.this.pathService.createFileName(name)));
                    changesPosted = true;
                }
            }
            if (key.subscribesTo(StandardWatchEventKinds.ENTRY_MODIFY)) {
                for (Map.Entry<Name, FileTime> entry : this.modifiedTimes.entrySet()) {
                    Name name;
                    name = entry.getKey();
                    FileTime modifiedTime = entry.getValue();
                    FileTime newModifiedTime = newState.modifiedTimes.get(name);
                    if (newModifiedTime == null || modifiedTime.equals(newModifiedTime)) continue;
                    key.post(new AbstractWatchService.Event<ZeroFsPath>(StandardWatchEventKinds.ENTRY_MODIFY, 1, PollingWatchService.this.pathService.createFileName(name)));
                    changesPosted = true;
                }
            }
            return changesPosted;
        }
    }

    private static class ZeroFsThreadFactory
    implements ThreadFactory {
        private final String nameFormat;
        private final boolean daemon;
        private final AtomicInteger count = new AtomicInteger(0);

        public ZeroFsThreadFactory(String nameFormat, boolean daemon) {
            this.nameFormat = nameFormat;
            this.daemon = daemon;
        }

        @Override
        public Thread newThread(Runnable r) {
            String threadName = String.format(this.nameFormat, this.count.getAndIncrement());
            Thread thread = new Thread(r, threadName);
            thread.setDaemon(this.daemon);
            return thread;
        }
    }
}

