/*
 * Decompiled with CFR 0.152.
 */
package io.roastedroot.zerofs;

import io.roastedroot.zerofs.PathType;
import java.nio.file.InvalidPathException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

final class WindowsPathType
extends PathType {
    static final WindowsPathType INSTANCE = new WindowsPathType();
    private static final Pattern WORKING_DIR_WITH_DRIVE = Pattern.compile("^[a-zA-Z]:([^\\\\].*)?$");
    private static final Pattern TRAILING_SPACES = Pattern.compile("[ ]+(\\\\|$)");
    private static final Pattern UNC_ROOT = Pattern.compile("^(\\\\\\\\)([^\\\\]+)?(\\\\[^\\\\]+)?");
    private static final Pattern DRIVE_LETTER_ROOT = Pattern.compile("^[a-zA-Z]:\\\\");

    private WindowsPathType() {
        super(true, '\\', '/');
    }

    @Override
    public PathType.ParseResult parsePath(String path) {
        int startIndex;
        Object root;
        String original = path;
        if (WORKING_DIR_WITH_DRIVE.matcher(path = path.replace('/', '\\')).matches()) {
            throw new InvalidPathException(original, "ZeroFs does not currently support the Windows syntax for a relative path on a specific drive (e.g. \"C:foo\\bar\")");
        }
        if (path.startsWith("\\\\")) {
            root = this.parseUncRoot(path, original);
        } else {
            if (path.startsWith("\\")) {
                throw new InvalidPathException(original, "ZeroFs does not currently support the Windows syntax for an absolute path on the current drive (e.g. \"\\foo\\bar\")");
            }
            root = this.parseDriveRoot(path);
        }
        for (int i = startIndex = root == null || ((String)root).length() > 3 ? 0 : ((String)root).length(); i < path.length(); ++i) {
            char c = path.charAt(i);
            if (!WindowsPathType.isReserved(c)) continue;
            throw new InvalidPathException(original, "Illegal char <" + c + ">", i);
        }
        Matcher trailingSpaceMatcher = TRAILING_SPACES.matcher(path);
        if (trailingSpaceMatcher.find()) {
            throw new InvalidPathException(original, "Trailing char < >", trailingSpaceMatcher.start());
        }
        if (root != null) {
            path = path.substring(((String)root).length());
            if (!((String)root).endsWith("\\")) {
                root = (String)root + "\\";
            }
        }
        return new PathType.ParseResult((String)root, this.split(path));
    }

    private String parseUncRoot(String path, String original) {
        Matcher uncMatcher = UNC_ROOT.matcher(path);
        if (uncMatcher.find()) {
            String host = uncMatcher.group(2);
            if (host == null) {
                throw new InvalidPathException(original, "UNC path is missing hostname");
            }
            String share = uncMatcher.group(3);
            if (share == null) {
                throw new InvalidPathException(original, "UNC path is missing sharename");
            }
            return path.substring(uncMatcher.start(), uncMatcher.end());
        }
        throw new InvalidPathException(original, "Invalid UNC path");
    }

    private String parseDriveRoot(String path) {
        Matcher drivePathMatcher = DRIVE_LETTER_ROOT.matcher(path);
        if (drivePathMatcher.find()) {
            return path.substring(drivePathMatcher.start(), drivePathMatcher.end());
        }
        return null;
    }

    private static boolean isReserved(char c) {
        switch (c) {
            case '\"': 
            case '*': 
            case ':': 
            case '<': 
            case '>': 
            case '?': 
            case '|': {
                return true;
            }
        }
        return c <= '\u001f';
    }

    @Override
    public String toString(String root, String[] names) {
        StringBuilder builder = new StringBuilder();
        if (root != null) {
            builder.append(root);
        }
        builder.append(this.join(names));
        return builder.toString();
    }

    @Override
    public String toUriPath(String root, String[] names, boolean directory) {
        root = ((String)root).startsWith("\\\\") ? ((String)root).replace('\\', '/') : "/" + ((String)root).replace('\\', '/');
        StringBuilder builder = new StringBuilder();
        builder.append((String)root);
        for (int i = 0; i < names.length; ++i) {
            if (i == 0) {
                builder.append(names[i]);
                continue;
            }
            builder.append('/').append(names[i]);
        }
        if (directory && builder.charAt(builder.length() - 1) != '/') {
            builder.append('/');
        }
        return builder.toString();
    }

    @Override
    public PathType.ParseResult parseUriPath(String uriPath) {
        if ((uriPath = uriPath.replace('/', '\\')).charAt(0) == '\\' && uriPath.charAt(1) != '\\') {
            uriPath = uriPath.substring(1);
        }
        return this.parsePath(uriPath);
    }
}

