/*
 * Decompiled with CFR 0.152.
 */
package io.roastedroot.zerofs;

import io.roastedroot.zerofs.Util;
import io.roastedroot.zerofs.ZeroFsFileChannel;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousFileChannel;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.CompletionHandler;
import java.nio.channels.FileLock;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;

final class ZeroFsAsynchronousFileChannel
extends AsynchronousFileChannel {
    private final ZeroFsFileChannel channel;
    private final CompletableListeningExecutor executor;

    public ZeroFsAsynchronousFileChannel(ZeroFsFileChannel channel, ExecutorService executor) {
        this.channel = Objects.requireNonNull(channel);
        this.executor = new CompletableListeningExecutor(executor);
    }

    @Override
    public long size() throws IOException {
        return this.channel.size();
    }

    private <R, A> void addCallback(CompletableFuture<R> future, CompletionHandler<R, ? super A> handler, A attachment) {
        future.whenCompleteAsync((result, throwable) -> {
            if (throwable != null) {
                handler.failed((Throwable)throwable, (Object)attachment);
            } else {
                handler.completed((Object)result, (Object)attachment);
            }
        }, (Executor)this.executor.getExecutor());
    }

    @Override
    public AsynchronousFileChannel truncate(long size) throws IOException {
        this.channel.truncate(size);
        return this;
    }

    @Override
    public void force(boolean metaData) throws IOException {
        this.channel.force(metaData);
    }

    @Override
    public <A> void lock(long position, long size, boolean shared, A attachment, CompletionHandler<FileLock, ? super A> handler) {
        Objects.requireNonNull(handler);
        this.addCallback((CompletableFuture)this.lock(position, size, shared), (CompletionHandler)handler, attachment);
    }

    public CompletableFuture<FileLock> lock(final long position, final long size, final boolean shared) {
        Util.checkNotNegative(position, "position");
        Util.checkNotNegative(size, "size");
        if (!this.isOpen()) {
            return ZeroFsAsynchronousFileChannel.closedChannelFuture();
        }
        if (shared) {
            this.channel.checkReadable();
        } else {
            this.channel.checkWritable();
        }
        return this.executor.submit(new Callable<FileLock>(){

            @Override
            public FileLock call() throws IOException {
                return ZeroFsAsynchronousFileChannel.this.tryLock(position, size, shared);
            }
        });
    }

    @Override
    public FileLock tryLock(long position, long size, boolean shared) throws IOException {
        Util.checkNotNegative(position, "position");
        Util.checkNotNegative(size, "size");
        this.channel.checkOpen();
        if (shared) {
            this.channel.checkReadable();
        } else {
            this.channel.checkWritable();
        }
        return new ZeroFsFileChannel.FakeFileLock(this, position, size, shared);
    }

    @Override
    public <A> void read(ByteBuffer dst, long position, A attachment, CompletionHandler<Integer, ? super A> handler) {
        this.addCallback((CompletableFuture)this.read(dst, position), (CompletionHandler)handler, attachment);
    }

    public CompletableFuture<Integer> read(final ByteBuffer dst, final long position) {
        if (dst.isReadOnly()) {
            throw new IllegalArgumentException("dst may not be read-only");
        }
        Util.checkNotNegative(position, "position");
        if (!this.isOpen()) {
            return ZeroFsAsynchronousFileChannel.closedChannelFuture();
        }
        this.channel.checkReadable();
        return this.executor.submit(new Callable<Integer>(){

            @Override
            public Integer call() throws IOException {
                return ZeroFsAsynchronousFileChannel.this.channel.read(dst, position);
            }
        });
    }

    @Override
    public <A> void write(ByteBuffer src, long position, A attachment, CompletionHandler<Integer, ? super A> handler) {
        this.addCallback((CompletableFuture)this.write(src, position), (CompletionHandler)handler, attachment);
    }

    public CompletableFuture<Integer> write(final ByteBuffer src, final long position) {
        Util.checkNotNegative(position, "position");
        if (!this.isOpen()) {
            return ZeroFsAsynchronousFileChannel.closedChannelFuture();
        }
        this.channel.checkWritable();
        return this.executor.submit(new Callable<Integer>(){

            @Override
            public Integer call() throws IOException {
                return ZeroFsAsynchronousFileChannel.this.channel.write(src, position);
            }
        });
    }

    @Override
    public boolean isOpen() {
        return this.channel.isOpen();
    }

    @Override
    public void close() throws IOException {
        this.channel.close();
    }

    private static <V> CompletableFuture<V> closedChannelFuture() {
        CompletableFuture future = new CompletableFuture();
        future.completeExceptionally(new ClosedChannelException());
        return future;
    }

    public class CompletableListeningExecutor {
        private final ExecutorService delegate;

        public CompletableListeningExecutor(ExecutorService delegate) {
            this.delegate = delegate;
        }

        public <T> CompletableFuture<T> submit(Callable<T> task) {
            CompletableFuture future = new CompletableFuture();
            this.delegate.submit(() -> {
                try {
                    Object result = task.call();
                    future.complete(result);
                }
                catch (Throwable t) {
                    future.completeExceptionally(t);
                }
            });
            return future;
        }

        public CompletableFuture<Void> submit(Runnable task) {
            return this.submit(() -> {
                task.run();
                return null;
            });
        }

        public void shutdown() {
            this.delegate.shutdown();
        }

        public ExecutorService getExecutor() {
            return this.delegate;
        }
    }
}

