/*
 * Decompiled with CFR 0.152.
 */
package io.roastedroot.zerofs;

import io.roastedroot.zerofs.AttributeCopyOption;
import io.roastedroot.zerofs.AttributeService;
import io.roastedroot.zerofs.Directory;
import io.roastedroot.zerofs.DirectoryEntry;
import io.roastedroot.zerofs.Feature;
import io.roastedroot.zerofs.File;
import io.roastedroot.zerofs.FileFactory;
import io.roastedroot.zerofs.FileLookup;
import io.roastedroot.zerofs.FileSystemState;
import io.roastedroot.zerofs.FileTree;
import io.roastedroot.zerofs.HeapDisk;
import io.roastedroot.zerofs.Name;
import io.roastedroot.zerofs.RegularFile;
import io.roastedroot.zerofs.SymbolicLink;
import io.roastedroot.zerofs.ZeroFsPath;
import java.io.IOException;
import java.nio.file.FileStore;
import java.nio.file.LinkOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileAttributeView;
import java.nio.file.attribute.FileStoreAttributeView;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.SortedSet;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Supplier;

final class ZeroFsFileStore
extends FileStore {
    private final FileTree tree;
    private final HeapDisk disk;
    private final AttributeService attributes;
    private final FileFactory factory;
    private final Set<Feature> supportedFeatures;
    private final FileSystemState state;
    private final Lock readLock;
    private final Lock writeLock;

    public ZeroFsFileStore(FileTree tree, FileFactory factory, HeapDisk disk, AttributeService attributes, Set<Feature> supportedFeatures, FileSystemState state) {
        this.tree = Objects.requireNonNull(tree);
        this.factory = Objects.requireNonNull(factory);
        this.disk = Objects.requireNonNull(disk);
        this.attributes = Objects.requireNonNull(attributes);
        this.supportedFeatures = Objects.requireNonNull(supportedFeatures);
        this.state = Objects.requireNonNull(state);
        ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
        this.readLock = lock.readLock();
        this.writeLock = lock.writeLock();
    }

    FileSystemState state() {
        return this.state;
    }

    Lock readLock() {
        return this.readLock;
    }

    Lock writeLock() {
        return this.writeLock;
    }

    SortedSet<Name> getRootDirectoryNames() {
        this.state.checkOpen();
        return this.tree.getRootDirectoryNames();
    }

    Directory getRoot(Name name) {
        DirectoryEntry entry = this.tree.getRoot(name);
        return entry == null ? null : (Directory)entry.file();
    }

    boolean supportsFeature(Feature feature) {
        return this.supportedFeatures.contains((Object)feature);
    }

    DirectoryEntry lookUp(File workingDirectory, ZeroFsPath path, Set<? super LinkOption> options) throws IOException {
        this.state.checkOpen();
        return this.tree.lookUp(workingDirectory, path, options);
    }

    Supplier<RegularFile> regularFileCreator() {
        this.state.checkOpen();
        return this.factory.regularFileCreator();
    }

    Supplier<Directory> directoryCreator() {
        this.state.checkOpen();
        return this.factory.directoryCreator();
    }

    Supplier<SymbolicLink> symbolicLinkCreator(ZeroFsPath target) {
        this.state.checkOpen();
        return this.factory.symbolicLinkCreator(target);
    }

    File copyWithoutContent(File file, AttributeCopyOption attributeCopyOption) throws IOException {
        File copy = this.factory.copyWithoutContent(file);
        this.setInitialAttributes(copy, new FileAttribute[0]);
        this.attributes.copyAttributes(file, copy, attributeCopyOption);
        return copy;
    }

    void setInitialAttributes(File file, FileAttribute<?> ... attrs) {
        this.state.checkOpen();
        this.attributes.setInitialAttributes(file, attrs);
    }

    <V extends FileAttributeView> V getFileAttributeView(FileLookup lookup, Class<V> type) {
        this.state.checkOpen();
        return this.attributes.getFileAttributeView(lookup, type);
    }

    Map<String, Object> readAttributes(File file, String attributes) {
        this.state.checkOpen();
        return this.attributes.readAttributes(file, attributes);
    }

    <A extends BasicFileAttributes> A readAttributes(File file, Class<A> type) {
        this.state.checkOpen();
        return this.attributes.readAttributes(file, type);
    }

    void setAttribute(File file, String attribute, Object value) {
        this.state.checkOpen();
        this.attributes.setAttribute(file, attribute, value, false);
    }

    Set<String> supportedFileAttributeViews() {
        this.state.checkOpen();
        return this.attributes.supportedFileAttributeViews();
    }

    @Override
    public String name() {
        return "zerofs";
    }

    @Override
    public String type() {
        return "zerofs";
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public long getTotalSpace() throws IOException {
        this.state.checkOpen();
        return this.disk.getTotalSpace();
    }

    @Override
    public long getUsableSpace() throws IOException {
        this.state.checkOpen();
        return this.getUnallocatedSpace();
    }

    @Override
    public long getUnallocatedSpace() throws IOException {
        this.state.checkOpen();
        return this.disk.getUnallocatedSpace();
    }

    @Override
    public boolean supportsFileAttributeView(Class<? extends FileAttributeView> type) {
        this.state.checkOpen();
        return this.attributes.supportsFileAttributeView(type);
    }

    @Override
    public boolean supportsFileAttributeView(String name) {
        this.state.checkOpen();
        return this.attributes.supportedFileAttributeViews().contains(name);
    }

    @Override
    public <V extends FileStoreAttributeView> V getFileStoreAttributeView(Class<V> type) {
        this.state.checkOpen();
        return null;
    }

    @Override
    public Object getAttribute(String attribute) throws IOException {
        throw new UnsupportedOperationException();
    }
}

