/*
 * Decompiled with CFR 0.152.
 */
package io.roastedroot.zerofs;

import io.roastedroot.zerofs.FileSystemView;
import io.roastedroot.zerofs.Name;
import io.roastedroot.zerofs.PathService;
import io.roastedroot.zerofs.UserLookupService;
import io.roastedroot.zerofs.WatchServiceConfiguration;
import io.roastedroot.zerofs.ZeroFsFileStore;
import io.roastedroot.zerofs.ZeroFsFileSystemProvider;
import io.roastedroot.zerofs.ZeroFsPath;
import java.io.Closeable;
import java.io.IOException;
import java.net.URI;
import java.nio.file.FileStore;
import java.nio.file.FileSystem;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.WatchService;
import java.nio.file.attribute.UserPrincipalLookupService;
import java.util.Objects;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

final class ZeroFsFileSystem
extends FileSystem {
    private final ZeroFsFileSystemProvider provider;
    private final URI uri;
    private final ZeroFsFileStore fileStore;
    private final PathService pathService;
    private final UserPrincipalLookupService userLookupService = new UserLookupService(true);
    private final FileSystemView defaultView;
    private final WatchServiceConfiguration watchServiceConfig;
    private ExecutorService defaultThreadPool;

    ZeroFsFileSystem(ZeroFsFileSystemProvider provider, URI uri, ZeroFsFileStore fileStore, PathService pathService, FileSystemView defaultView, WatchServiceConfiguration watchServiceConfig) {
        this.provider = Objects.requireNonNull(provider);
        this.uri = Objects.requireNonNull(uri);
        this.fileStore = Objects.requireNonNull(fileStore);
        this.pathService = Objects.requireNonNull(pathService);
        this.defaultView = Objects.requireNonNull(defaultView);
        this.watchServiceConfig = Objects.requireNonNull(watchServiceConfig);
    }

    @Override
    public ZeroFsFileSystemProvider provider() {
        return this.provider;
    }

    public URI getUri() {
        return this.uri;
    }

    public FileSystemView getDefaultView() {
        return this.defaultView;
    }

    @Override
    public String getSeparator() {
        return this.pathService.getSeparator();
    }

    public SortedSet<Path> getRootDirectories() {
        TreeSet<Path> builder = new TreeSet<Path>(this.pathService);
        for (Name name : this.fileStore.getRootDirectoryNames()) {
            builder.add(this.pathService.createRoot(name));
        }
        return builder;
    }

    public ZeroFsPath getWorkingDirectory() {
        return this.defaultView.getWorkingDirectoryPath();
    }

    PathService getPathService() {
        return this.pathService;
    }

    public ZeroFsFileStore getFileStore() {
        return this.fileStore;
    }

    public Set<FileStore> getFileStores() {
        this.fileStore.state().checkOpen();
        return Set.of(this.fileStore);
    }

    @Override
    public Set<String> supportedFileAttributeViews() {
        return this.fileStore.supportedFileAttributeViews();
    }

    @Override
    public ZeroFsPath getPath(String first, String ... more) {
        this.fileStore.state().checkOpen();
        return this.pathService.parsePath(first, more);
    }

    public URI toUri(ZeroFsPath path) {
        this.fileStore.state().checkOpen();
        return this.pathService.toUri(this.uri, path.toAbsolutePath());
    }

    public ZeroFsPath toPath(URI uri) {
        this.fileStore.state().checkOpen();
        return this.pathService.fromUri(uri);
    }

    @Override
    public PathMatcher getPathMatcher(String syntaxAndPattern) {
        this.fileStore.state().checkOpen();
        return this.pathService.createPathMatcher(syntaxAndPattern);
    }

    @Override
    public UserPrincipalLookupService getUserPrincipalLookupService() {
        this.fileStore.state().checkOpen();
        return this.userLookupService;
    }

    @Override
    public WatchService newWatchService() throws IOException {
        return this.watchServiceConfig.newWatchService(this.defaultView, this.pathService);
    }

    public synchronized ExecutorService getDefaultThreadPool() {
        if (this.defaultThreadPool == null) {
            String host = this.uri.getHost();
            String nameFormat = "ZeroFsFileSystem-" + host + "-defaultThreadPool-%d";
            AtomicInteger count = new AtomicInteger(0);
            ThreadFactory threadFactory = r -> {
                Thread thread = new Thread(r);
                thread.setDaemon(true);
                thread.setName(String.format(nameFormat, count.getAndIncrement()));
                return thread;
            };
            this.defaultThreadPool = Executors.newCachedThreadPool(threadFactory);
            this.fileStore.state().register(new Closeable(){

                @Override
                public void close() {
                    ZeroFsFileSystem.this.defaultThreadPool.shutdown();
                }
            });
        }
        return this.defaultThreadPool;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public boolean isOpen() {
        return this.fileStore.state().isOpen();
    }

    @Override
    public void close() throws IOException {
        this.fileStore.state().close();
    }
}

