/*
 * Decompiled with CFR 0.152.
 */
package io.roastedroot.zerofs;

import io.roastedroot.zerofs.DowngradedSeekableByteChannel;
import io.roastedroot.zerofs.Feature;
import io.roastedroot.zerofs.FileSystemView;
import io.roastedroot.zerofs.Handler;
import io.roastedroot.zerofs.Options;
import io.roastedroot.zerofs.RegularFile;
import io.roastedroot.zerofs.ZeroFsFileChannel;
import io.roastedroot.zerofs.ZeroFsFileSystem;
import io.roastedroot.zerofs.ZeroFsInputStream;
import io.roastedroot.zerofs.ZeroFsOutputStream;
import io.roastedroot.zerofs.ZeroFsPath;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.nio.channels.AsynchronousFileChannel;
import java.nio.channels.FileChannel;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.AccessMode;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.FileStore;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.ProviderMismatchException;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.DosFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileAttributeView;
import java.nio.file.spi.FileSystemProvider;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ExecutorService;

final class ZeroFsFileSystemProvider
extends FileSystemProvider {
    private static final ZeroFsFileSystemProvider INSTANCE = new ZeroFsFileSystemProvider();
    private static final FileAttribute<?>[] NO_ATTRS;

    ZeroFsFileSystemProvider() {
    }

    static ZeroFsFileSystemProvider instance() {
        return INSTANCE;
    }

    @Override
    public String getScheme() {
        return "zerofs";
    }

    @Override
    public FileSystem newFileSystem(URI uri, Map<String, ?> env) throws IOException {
        throw new UnsupportedOperationException("This method should not be called directly;use an overload of ZeroFs.newFileSystem() to create a FileSystem.");
    }

    @Override
    public FileSystem newFileSystem(Path path, Map<String, ?> env) throws IOException {
        ZeroFsPath checkedPath = ZeroFsFileSystemProvider.checkPath(path);
        Objects.requireNonNull(env);
        URI pathUri = checkedPath.toUri();
        URI jarUri = URI.create("jar:" + String.valueOf(pathUri));
        try {
            return FileSystems.newFileSystem(jarUri, env);
        }
        catch (Exception e) {
            throw new UnsupportedOperationException(e);
        }
    }

    @Override
    public FileSystem getFileSystem(URI uri) {
        throw new UnsupportedOperationException("This method should not be called directly; use FileSystems.getFileSystem(URI) instead.");
    }

    private static ZeroFsFileSystem getFileSystem(Path path) {
        return (ZeroFsFileSystem)ZeroFsFileSystemProvider.checkPath(path).getFileSystem();
    }

    @Override
    public Path getPath(URI uri) {
        throw new UnsupportedOperationException("This method should not be called directly; use Paths.get(URI) instead.");
    }

    private static ZeroFsPath checkPath(Path path) {
        if (path instanceof ZeroFsPath) {
            return (ZeroFsPath)path;
        }
        throw new ProviderMismatchException("path " + String.valueOf(path) + " is not associated with a ZeroFs file system");
    }

    private static FileSystemView getDefaultView(ZeroFsPath path) {
        return ZeroFsFileSystemProvider.getFileSystem(path).getDefaultView();
    }

    @Override
    public FileChannel newFileChannel(Path path, Set<? extends OpenOption> options, FileAttribute<?> ... attrs) throws IOException {
        ZeroFsPath checkedPath = ZeroFsFileSystemProvider.checkPath(path);
        if (!checkedPath.getZeroFsFileSystem().getFileStore().supportsFeature(Feature.FILE_CHANNEL)) {
            throw new UnsupportedOperationException();
        }
        return this.newZeroFsFileChannel(checkedPath, options, attrs);
    }

    private ZeroFsFileChannel newZeroFsFileChannel(ZeroFsPath path, Set<? extends OpenOption> options, FileAttribute<?> ... attrs) throws IOException {
        Set<OpenOption> opts = Options.getOptionsForChannel(options);
        FileSystemView view = ZeroFsFileSystemProvider.getDefaultView(path);
        RegularFile file = view.getOrCreateRegularFile(path, opts, attrs);
        return new ZeroFsFileChannel(file, opts, view.state());
    }

    @Override
    public SeekableByteChannel newByteChannel(Path path, Set<? extends OpenOption> options, FileAttribute<?> ... attrs) throws IOException {
        ZeroFsPath checkedPath = ZeroFsFileSystemProvider.checkPath(path);
        ZeroFsFileChannel channel = this.newZeroFsFileChannel(checkedPath, options, attrs);
        return checkedPath.getZeroFsFileSystem().getFileStore().supportsFeature(Feature.FILE_CHANNEL) ? channel : new DowngradedSeekableByteChannel(channel);
    }

    @Override
    public AsynchronousFileChannel newAsynchronousFileChannel(Path path, Set<? extends OpenOption> options, ExecutorService executor, FileAttribute<?> ... attrs) throws IOException {
        ZeroFsFileChannel channel = (ZeroFsFileChannel)this.newFileChannel(path, options, attrs);
        if (executor == null) {
            ZeroFsFileSystem fileSystem = (ZeroFsFileSystem)path.getFileSystem();
            executor = fileSystem.getDefaultThreadPool();
        }
        return channel.asAsynchronousFileChannel(executor);
    }

    @Override
    public InputStream newInputStream(Path path, OpenOption ... options) throws IOException {
        ZeroFsPath checkedPath = ZeroFsFileSystemProvider.checkPath(path);
        Set<OpenOption> opts = Options.getOptionsForInputStream(options);
        FileSystemView view = ZeroFsFileSystemProvider.getDefaultView(checkedPath);
        RegularFile file = view.getOrCreateRegularFile(checkedPath, opts, NO_ATTRS);
        return new ZeroFsInputStream(file, view.state());
    }

    @Override
    public OutputStream newOutputStream(Path path, OpenOption ... options) throws IOException {
        ZeroFsPath checkedPath = ZeroFsFileSystemProvider.checkPath(path);
        Set<OpenOption> opts = Options.getOptionsForOutputStream(options);
        FileSystemView view = ZeroFsFileSystemProvider.getDefaultView(checkedPath);
        RegularFile file = view.getOrCreateRegularFile(checkedPath, opts, NO_ATTRS);
        return new ZeroFsOutputStream(file, opts.contains(StandardOpenOption.APPEND), view.state());
    }

    @Override
    public DirectoryStream<Path> newDirectoryStream(Path dir, DirectoryStream.Filter<? super Path> filter) throws IOException {
        ZeroFsPath checkedPath = ZeroFsFileSystemProvider.checkPath(dir);
        return ZeroFsFileSystemProvider.getDefaultView(checkedPath).newDirectoryStream(checkedPath, filter, Options.FOLLOW_LINKS, checkedPath);
    }

    @Override
    public void createDirectory(Path dir, FileAttribute<?> ... attrs) throws IOException {
        ZeroFsPath checkedPath = ZeroFsFileSystemProvider.checkPath(dir);
        FileSystemView view = ZeroFsFileSystemProvider.getDefaultView(checkedPath);
        view.createDirectory(checkedPath, attrs);
    }

    @Override
    public void createLink(Path link, Path existing) throws IOException {
        ZeroFsPath linkPath = ZeroFsFileSystemProvider.checkPath(link);
        ZeroFsPath existingPath = ZeroFsFileSystemProvider.checkPath(existing);
        if (!linkPath.getFileSystem().equals(existingPath.getFileSystem())) {
            throw new IllegalArgumentException("link and existing paths must belong to the same file system instance");
        }
        FileSystemView view = ZeroFsFileSystemProvider.getDefaultView(linkPath);
        view.link(linkPath, ZeroFsFileSystemProvider.getDefaultView(existingPath), existingPath);
    }

    @Override
    public void createSymbolicLink(Path link, Path target, FileAttribute<?> ... attrs) throws IOException {
        ZeroFsPath linkPath = ZeroFsFileSystemProvider.checkPath(link);
        ZeroFsPath targetPath = ZeroFsFileSystemProvider.checkPath(target);
        if (!linkPath.getFileSystem().equals(targetPath.getFileSystem())) {
            throw new IllegalArgumentException("link and target paths must belong to the same file system instance");
        }
        FileSystemView view = ZeroFsFileSystemProvider.getDefaultView(linkPath);
        view.createSymbolicLink(linkPath, targetPath, attrs);
    }

    @Override
    public Path readSymbolicLink(Path link) throws IOException {
        ZeroFsPath checkedPath = ZeroFsFileSystemProvider.checkPath(link);
        return ZeroFsFileSystemProvider.getDefaultView(checkedPath).readSymbolicLink(checkedPath);
    }

    @Override
    public void delete(Path path) throws IOException {
        ZeroFsPath checkedPath = ZeroFsFileSystemProvider.checkPath(path);
        FileSystemView view = ZeroFsFileSystemProvider.getDefaultView(checkedPath);
        view.deleteFile(checkedPath, FileSystemView.DeleteMode.ANY);
    }

    @Override
    public void copy(Path source, Path target, CopyOption ... options) throws IOException {
        this.copy(source, target, Options.getCopyOptions(options), false);
    }

    private void copy(Path source, Path target, Set<CopyOption> options, boolean move) throws IOException {
        ZeroFsPath sourcePath = ZeroFsFileSystemProvider.checkPath(source);
        ZeroFsPath targetPath = ZeroFsFileSystemProvider.checkPath(target);
        FileSystemView sourceView = ZeroFsFileSystemProvider.getDefaultView(sourcePath);
        FileSystemView targetView = ZeroFsFileSystemProvider.getDefaultView(targetPath);
        sourceView.copy(sourcePath, targetView, targetPath, options, move);
    }

    @Override
    public void move(Path source, Path target, CopyOption ... options) throws IOException {
        this.copy(source, target, Options.getMoveOptions(options), true);
    }

    @Override
    public boolean isSameFile(Path path, Path path2) throws IOException {
        if (path.equals(path2)) {
            return true;
        }
        if (!(path instanceof ZeroFsPath) || !(path2 instanceof ZeroFsPath)) {
            return false;
        }
        ZeroFsPath checkedPath = (ZeroFsPath)path;
        ZeroFsPath checkedPath2 = (ZeroFsPath)path2;
        FileSystemView view = ZeroFsFileSystemProvider.getDefaultView(checkedPath);
        FileSystemView view2 = ZeroFsFileSystemProvider.getDefaultView(checkedPath2);
        return view.isSameFile(checkedPath, view2, checkedPath2);
    }

    @Override
    public boolean isHidden(Path path) throws IOException {
        ZeroFsPath checkedPath = ZeroFsFileSystemProvider.checkPath(path);
        FileSystemView view = ZeroFsFileSystemProvider.getDefaultView(checkedPath);
        if (this.getFileStore(path).supportsFileAttributeView("dos")) {
            return view.readAttributes(checkedPath, DosFileAttributes.class, Options.NOFOLLOW_LINKS).isHidden();
        }
        return path.getNameCount() > 0 && path.getFileName().toString().startsWith(".");
    }

    @Override
    public FileStore getFileStore(Path path) throws IOException {
        return ZeroFsFileSystemProvider.getFileSystem(path).getFileStore();
    }

    @Override
    public void checkAccess(Path path, AccessMode ... modes) throws IOException {
        ZeroFsPath checkedPath = ZeroFsFileSystemProvider.checkPath(path);
        ZeroFsFileSystemProvider.getDefaultView(checkedPath).checkAccess(checkedPath);
    }

    @Override
    public <V extends FileAttributeView> V getFileAttributeView(Path path, Class<V> type, LinkOption ... options) {
        ZeroFsPath checkedPath = ZeroFsFileSystemProvider.checkPath(path);
        return ZeroFsFileSystemProvider.getDefaultView(checkedPath).getFileAttributeView(checkedPath, type, Options.getLinkOptions(options));
    }

    @Override
    public <A extends BasicFileAttributes> A readAttributes(Path path, Class<A> type, LinkOption ... options) throws IOException {
        ZeroFsPath checkedPath = ZeroFsFileSystemProvider.checkPath(path);
        return ZeroFsFileSystemProvider.getDefaultView(checkedPath).readAttributes(checkedPath, type, Options.getLinkOptions(options));
    }

    @Override
    public Map<String, Object> readAttributes(Path path, String attributes, LinkOption ... options) throws IOException {
        ZeroFsPath checkedPath = ZeroFsFileSystemProvider.checkPath(path);
        return ZeroFsFileSystemProvider.getDefaultView(checkedPath).readAttributes(checkedPath, attributes, Options.getLinkOptions(options));
    }

    @Override
    public void setAttribute(Path path, String attribute, Object value, LinkOption ... options) throws IOException {
        ZeroFsPath checkedPath = ZeroFsFileSystemProvider.checkPath(path);
        ZeroFsFileSystemProvider.getDefaultView(checkedPath).setAttribute(checkedPath, attribute, value, Options.getLinkOptions(options));
    }

    static {
        try {
            Handler.register();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        NO_ATTRS = new FileAttribute[0];
    }
}

