/*
 * Decompiled with CFR 0.152.
 */
package io.roastedroot.zerofs;

import io.roastedroot.zerofs.File;
import io.roastedroot.zerofs.FileLookup;
import io.roastedroot.zerofs.FileSystemState;
import io.roastedroot.zerofs.FileSystemView;
import io.roastedroot.zerofs.Name;
import io.roastedroot.zerofs.Options;
import io.roastedroot.zerofs.ZeroFsFileChannel;
import io.roastedroot.zerofs.ZeroFsPath;
import java.io.IOException;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.ClosedDirectoryStreamException;
import java.nio.file.DirectoryIteratorException;
import java.nio.file.DirectoryStream;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.ProviderMismatchException;
import java.nio.file.SecureDirectoryStream;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileAttributeView;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;

final class ZeroFsSecureDirectoryStream
implements SecureDirectoryStream<Path> {
    private final FileSystemView view;
    private final DirectoryStream.Filter<? super Path> filter;
    private final FileSystemState fileSystemState;
    private boolean open = true;
    private Iterator<Path> iterator = new DirectoryIterator();
    public static final DirectoryStream.Filter<Object> ALWAYS_TRUE_FILTER = new DirectoryStream.Filter<Object>(){

        @Override
        public boolean accept(Object entry) throws IOException {
            return true;
        }
    };

    public ZeroFsSecureDirectoryStream(FileSystemView view, DirectoryStream.Filter<? super Path> filter, FileSystemState fileSystemState) {
        this.view = Objects.requireNonNull(view);
        this.filter = Objects.requireNonNull(filter);
        this.fileSystemState = fileSystemState;
        fileSystemState.register(this);
    }

    private ZeroFsPath path() {
        return this.view.getWorkingDirectoryPath();
    }

    @Override
    public synchronized Iterator<Path> iterator() {
        this.checkOpen();
        Iterator<Path> result = this.iterator;
        if (result == null) {
            throw new IllegalStateException("iterator() has already been called once");
        }
        this.iterator = null;
        return result;
    }

    @Override
    public synchronized void close() {
        this.open = false;
        this.fileSystemState.unregister(this);
    }

    protected synchronized void checkOpen() {
        if (!this.open) {
            throw new ClosedDirectoryStreamException();
        }
    }

    @Override
    public SecureDirectoryStream<Path> newDirectoryStream(Path path, LinkOption ... options) throws IOException {
        this.checkOpen();
        ZeroFsPath checkedPath = ZeroFsSecureDirectoryStream.checkPath(path);
        return (SecureDirectoryStream)this.view.newDirectoryStream(checkedPath, ALWAYS_TRUE_FILTER, Options.getLinkOptions(options), this.path().resolve(checkedPath));
    }

    @Override
    public SeekableByteChannel newByteChannel(Path path, Set<? extends OpenOption> options, FileAttribute<?> ... attrs) throws IOException {
        this.checkOpen();
        ZeroFsPath checkedPath = ZeroFsSecureDirectoryStream.checkPath(path);
        Set<OpenOption> opts = Options.getOptionsForChannel(options);
        return new ZeroFsFileChannel(this.view.getOrCreateRegularFile(checkedPath, opts, new FileAttribute[0]), opts, this.fileSystemState);
    }

    @Override
    public void deleteFile(Path path) throws IOException {
        this.checkOpen();
        ZeroFsPath checkedPath = ZeroFsSecureDirectoryStream.checkPath(path);
        this.view.deleteFile(checkedPath, FileSystemView.DeleteMode.NON_DIRECTORY_ONLY);
    }

    @Override
    public void deleteDirectory(Path path) throws IOException {
        this.checkOpen();
        ZeroFsPath checkedPath = ZeroFsSecureDirectoryStream.checkPath(path);
        this.view.deleteFile(checkedPath, FileSystemView.DeleteMode.DIRECTORY_ONLY);
    }

    @Override
    public void move(Path srcPath, SecureDirectoryStream<Path> targetDir, Path targetPath) throws IOException {
        this.checkOpen();
        ZeroFsPath checkedSrcPath = ZeroFsSecureDirectoryStream.checkPath(srcPath);
        ZeroFsPath checkedTargetPath = ZeroFsSecureDirectoryStream.checkPath(targetPath);
        if (!(targetDir instanceof ZeroFsSecureDirectoryStream)) {
            throw new ProviderMismatchException("targetDir isn't a secure directory stream associated with this file system");
        }
        ZeroFsSecureDirectoryStream checkedTargetDir = (ZeroFsSecureDirectoryStream)targetDir;
        this.view.copy(checkedSrcPath, checkedTargetDir.view, checkedTargetPath, Set.of(), true);
    }

    @Override
    public <V extends FileAttributeView> V getFileAttributeView(Class<V> type) {
        return this.getFileAttributeView(this.path().getFileSystem().getPath(".", new String[0]), type, new LinkOption[0]);
    }

    @Override
    public <V extends FileAttributeView> V getFileAttributeView(Path path, Class<V> type, LinkOption ... options) {
        this.checkOpen();
        final ZeroFsPath checkedPath = ZeroFsSecureDirectoryStream.checkPath(path);
        final Set<LinkOption> optionsSet = Options.getLinkOptions(options);
        return this.view.getFileAttributeView(new FileLookup(){

            @Override
            public File lookup() throws IOException {
                ZeroFsSecureDirectoryStream.this.checkOpen();
                return ZeroFsSecureDirectoryStream.this.view.lookUpWithLock(checkedPath, optionsSet).requireExists(checkedPath).file();
            }
        }, type);
    }

    private static ZeroFsPath checkPath(Path path) {
        if (path instanceof ZeroFsPath) {
            return (ZeroFsPath)path;
        }
        throw new ProviderMismatchException("path " + String.valueOf(path) + " is not associated with a ZeroFs file system");
    }

    public final class DirectoryIterator
    implements Iterator<Path> {
        private Iterator<Name> fileNames;
        private Path nextPath;
        private boolean nextPathReady = false;

        private void prepareNext() {
            if (this.nextPathReady) {
                return;
            }
            ZeroFsSecureDirectoryStream.this.checkOpen();
            try {
                if (this.fileNames == null) {
                    this.fileNames = ZeroFsSecureDirectoryStream.this.view.snapshotWorkingDirectoryEntries().iterator();
                }
                while (this.fileNames.hasNext()) {
                    Name name = this.fileNames.next();
                    ZeroFsPath path = ZeroFsSecureDirectoryStream.this.view.getWorkingDirectoryPath().resolve(name);
                    if (!ZeroFsSecureDirectoryStream.this.filter.accept(path)) continue;
                    this.nextPath = path;
                    this.nextPathReady = true;
                    return;
                }
                this.nextPath = null;
                this.nextPathReady = false;
            }
            catch (IOException e) {
                throw new DirectoryIteratorException(e);
            }
        }

        @Override
        public synchronized boolean hasNext() {
            this.prepareNext();
            return this.nextPathReady;
        }

        @Override
        public synchronized Path next() {
            this.prepareNext();
            if (!this.nextPathReady) {
                throw new NoSuchElementException();
            }
            Path result = this.nextPath;
            this.nextPath = null;
            this.nextPathReady = false;
            return result;
        }
    }
}

