/*
 * Decompiled with CFR 0.152.
 */
package io.rocketbase.extension;

import com.github.kagkarlsson.scheduler.task.ExecutionComplete;
import com.github.kagkarlsson.scheduler.task.TaskInstance;
import java.time.Instant;
import java.util.Objects;

public final class ExecutionLog {
    public final TaskInstance taskInstance;
    public final String pickedBy;
    public final Instant timeStarted;
    public final Instant timeFinished;
    public final boolean succeeded;
    public final Throwable cause;

    public ExecutionLog(ExecutionComplete exec) {
        this.taskInstance = exec.getExecution().taskInstance;
        this.pickedBy = exec.getExecution().pickedBy;
        this.timeStarted = exec.getTimeDone().minus(exec.getDuration());
        this.timeFinished = exec.getTimeDone();
        this.succeeded = ExecutionComplete.Result.OK.equals((Object)exec.getResult());
        this.cause = exec.getCause().orElse(null);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExecutionLog execLog = (ExecutionLog)o;
        return Objects.equals(this.timeStarted, execLog.timeStarted) && Objects.equals(this.timeFinished, execLog.timeFinished) && Objects.equals(this.taskInstance, execLog.taskInstance);
    }

    public int hashCode() {
        return Objects.hash(this.timeStarted, this.timeFinished, this.taskInstance);
    }

    public String toString() {
        return "ExecutionLog: task=" + this.taskInstance.getTaskName() + ", id=" + this.taskInstance.getId() + ", pickedBy=" + this.pickedBy + ", timeStarted=" + this.timeStarted + ", timeFinished=" + this.timeFinished + ", succeeded=" + this.succeeded;
    }
}

