/*
 * Decompiled with CFR 0.152.
 */
package io.rocketbase.extension.jdbc;

import com.github.kagkarlsson.scheduler.SchedulerName;
import io.rocketbase.extension.jdbc.IdProvider;
import java.security.SecureRandom;
import java.time.Instant;

public final class Snowflake
implements IdProvider {
    private static Snowflake INSTANCE;
    public static final int UNUSED_BITS = 1;
    public static final int EPOCH_BITS = 43;
    public static final int NODE_ID_BITS = 10;
    public static final int SEQUENCE_BITS = 10;
    public static final long maxNodeId = 1023L;
    public static final long maxSequence = 1023L;
    public static final long DEFAULT_CUSTOM_EPOCH = 1577836800000L;
    private final long nodeId;
    private final long customEpoch;
    private volatile long lastTimestamp = -1L;
    private volatile long sequence = 0L;

    public Snowflake(long nodeId, long customEpoch) {
        if (nodeId < 0L || nodeId > 1023L) {
            throw new IllegalArgumentException(String.format("NodeId must be between %d and %d", 0, 1023L));
        }
        this.nodeId = nodeId;
        this.customEpoch = customEpoch;
    }

    public Snowflake(long nodeId) {
        this(nodeId, 1577836800000L);
    }

    public Snowflake() {
        this.nodeId = this.createNodeId();
        this.customEpoch = 1577836800000L;
    }

    public static Snowflake getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new Snowflake();
        }
        return INSTANCE;
    }

    @Override
    public synchronized long nextId() {
        long currentTimestamp = this.timestamp();
        if (currentTimestamp < this.lastTimestamp) {
            throw new IllegalStateException("Invalid System Clock!");
        }
        if (currentTimestamp == this.lastTimestamp) {
            this.sequence = this.sequence + 1L & 0x3FFL;
            if (this.sequence == 0L) {
                currentTimestamp = this.waitNextMillis(currentTimestamp);
            }
        } else {
            this.sequence = 0L;
        }
        this.lastTimestamp = currentTimestamp;
        long id = currentTimestamp << 20 | this.nodeId << 10 | this.sequence;
        return id;
    }

    private long timestamp() {
        return Instant.now().toEpochMilli() - this.customEpoch;
    }

    private long waitNextMillis(long currentTimestamp) {
        while (currentTimestamp == this.lastTimestamp) {
            currentTimestamp = this.timestamp();
        }
        return currentTimestamp;
    }

    private long createNodeId() {
        long nodeId;
        try {
            nodeId = new SchedulerName.Hostname().hashCode();
        }
        catch (Exception ex) {
            nodeId = new SecureRandom().nextInt();
        }
        return nodeId &= 0x3FFL;
    }

    public long[] parse(long id) {
        long maskNodeId = 1047552L;
        long maskSequence = 1023L;
        long timestamp = (id >> 20) + this.customEpoch;
        long nodeId = (id & maskNodeId) >> 10;
        long sequence = id & maskSequence;
        return new long[]{timestamp, nodeId, sequence};
    }

    public String toString() {
        return "Snowflake Settings [EPOCH_BITS=43, NODE_ID_BITS=10, SEQUENCE_BITS=10, CUSTOM_EPOCH=" + this.customEpoch + ", NodeId=" + this.nodeId + "]";
    }
}

