/*
 * Decompiled with CFR 0.152.
 */
package io.rocketbase.extension.stats;

import com.github.kagkarlsson.scheduler.stats.MicrometerStatsRegistry;
import com.github.kagkarlsson.scheduler.task.ExecutionComplete;
import com.github.kagkarlsson.scheduler.task.Task;
import io.micrometer.core.instrument.MeterRegistry;
import io.rocketbase.extension.ExecutionLog;
import io.rocketbase.extension.LogRepository;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class LogStatsMicrometerRegistry
extends MicrometerStatsRegistry {
    private final LogRepository logRepository;
    private ExecutorService executorService;

    public LogStatsMicrometerRegistry(MeterRegistry meterRegistry, List<? extends Task<?>> expectedTasks, LogRepository logRepository) {
        super(meterRegistry, expectedTasks);
        this.logRepository = logRepository;
        this.executorService = Executors.newFixedThreadPool(5);
    }

    public void registerSingleCompletedExecution(ExecutionComplete completeEvent) {
        super.registerSingleCompletedExecution(completeEvent);
        this.executorService.submit(() -> this.logRepository.createIfNotExists(new ExecutionLog(completeEvent)));
    }
}

