/*
 * Decompiled with CFR 0.152.
 */
package io.rsocket.broker.client.spring;

import io.rsocket.RSocket;
import io.rsocket.broker.client.spring.BrokerClientProperties;
import io.rsocket.broker.client.spring.BrokerClientRSocketStrategiesAutoConfiguration;
import io.rsocket.broker.client.spring.BrokerMetadata;
import io.rsocket.broker.client.spring.BrokerRSocketRequester;
import io.rsocket.broker.client.spring.BrokerRSocketRequesterBuilder;
import io.rsocket.broker.common.Id;
import io.rsocket.broker.common.spring.ClientTransportFactory;
import io.rsocket.broker.common.spring.DefaultClientTransportFactory;
import io.rsocket.broker.common.spring.MimeTypes;
import io.rsocket.broker.frames.RouteSetup;
import io.rsocket.transport.ClientTransport;
import java.net.URI;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.rsocket.RSocketRequesterAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Scope;
import org.springframework.messaging.rsocket.RSocketConnectorConfigurer;
import org.springframework.messaging.rsocket.RSocketRequester;
import org.springframework.messaging.rsocket.RSocketStrategies;
import org.springframework.messaging.rsocket.annotation.support.RSocketMessageHandler;
import org.springframework.util.CollectionUtils;
import reactor.core.Disposable;
import reactor.core.publisher.Sinks;

@Configuration
@EnableConfigurationProperties
@ConditionalOnClass(value={RSocket.class, RSocketRequester.class})
@ConditionalOnProperty(name={"io.rsocket.broker.client.enabled"}, matchIfMissing=true)
@AutoConfigureAfter(value={BrokerClientRSocketStrategiesAutoConfiguration.class})
@AutoConfigureBefore(value={RSocketRequesterAutoConfiguration.class})
public class BrokerClientAutoConfiguration {
    @Bean
    public BrokerClientProperties brokerClientProperties() {
        return new BrokerClientProperties();
    }

    @Bean
    @Scope(value="prototype")
    @ConditionalOnMissingBean
    public BrokerRSocketRequesterBuilder brokerRSocketRequesterBuilder(RSocketConnectorConfigurer configurer, RSocketStrategies strategies, BrokerClientProperties properties) {
        RouteSetup.Builder routeSetup = RouteSetup.from((Id)properties.getRouteId(), (String)properties.getServiceName());
        properties.getTags().forEach((key, value) -> {
            if (key.getWellKnownKey() != null) {
                routeSetup.with(key.getWellKnownKey(), value);
            } else if (key.getKey() != null) {
                routeSetup.with(key.getKey(), value);
            }
        });
        RSocketRequester.Builder builder = RSocketRequester.builder().setupMetadata((Object)routeSetup.build(), MimeTypes.BROKER_FRAME_MIME_TYPE).rsocketStrategies(strategies).rsocketConnector(configurer);
        return new BrokerRSocketRequesterBuilder(builder, properties, strategies.routeMatcher());
    }

    @Bean
    @ConditionalOnMissingBean
    public RSocketConnectorConfigurer rSocketConnectorConfigurer(RSocketMessageHandler messageHandler) {
        return connector -> connector.acceptor(messageHandler.responder());
    }

    @Bean
    public BrokerMetadata brokerMetadata(BrokerClientProperties config) {
        return new BrokerMetadata(config);
    }

    @Bean
    public DefaultClientTransportFactory defaultClientTransportFactory() {
        return new DefaultClientTransportFactory();
    }

    @Bean
    @ConditionalOnProperty(name={"io.rsocket.broker.client.block"}, matchIfMissing=true)
    public ClientThreadManager clientThreadManager() {
        return new ClientThreadManager();
    }

    @Bean
    @ConditionalOnProperty(name={"io.rsocket.broker.client.auto-connect"}, matchIfMissing=true)
    public BrokerRSocketRequester brokerClientRSocketRequester(BrokerRSocketRequesterBuilder builder, BrokerClientProperties properties, ObjectProvider<ClientTransportFactory> transportFactories, ClientThreadManager ignored) {
        if (CollectionUtils.isEmpty(properties.getBrokers())) {
            throw new IllegalStateException("io.rsocket.broker.client.brokers may not be empty");
        }
        URI broker = properties.getBrokers().iterator().next();
        ClientTransport clientTransport = transportFactories.orderedStream().filter(factory -> factory.supports(broker)).findFirst().map(factory -> (ClientTransport)factory.create(broker)).orElseThrow(() -> new IllegalStateException("Unknown transport " + properties));
        BrokerRSocketRequester requester = builder.transport(clientTransport);
        requester.rsocketClient().source().subscribe();
        return requester;
    }

    private static class ClientThreadManager
    implements Disposable {
        private final Sinks.One<Void> onClose = Sinks.one();

        private ClientThreadManager() {
            Thread awaitThread = new Thread("broker-client-thread"){

                @Override
                public void run() {
                    onClose.asMono().block();
                }
            };
            awaitThread.setContextClassLoader(this.getClass().getClassLoader());
            awaitThread.setDaemon(false);
            awaitThread.start();
        }

        public void dispose() {
            this.onClose.emitEmpty((signalType, emitResult) -> false);
        }

        public boolean isDisposed() {
            return false;
        }
    }
}

