/*
 * Decompiled with CFR 0.152.
 */
package io.rsocket.broker.client.spring;

import io.rsocket.broker.client.spring.BrokerClientProperties;
import io.rsocket.broker.common.Id;
import io.rsocket.broker.common.WellKnownKey;
import io.rsocket.broker.common.spring.MimeTypes;
import io.rsocket.broker.frames.Address;
import java.util.function.Consumer;
import org.springframework.messaging.rsocket.RSocketRequester;

public class BrokerMetadata {
    private final BrokerClientProperties properties;

    public BrokerMetadata(BrokerClientProperties properties) {
        this.properties = properties;
    }

    BrokerClientProperties getProperties() {
        return this.properties;
    }

    public Consumer<RSocketRequester.MetadataSpec<?>> address(String destServiceName) {
        return spec -> {
            Address address = ((Address.Builder)Address.from((Id)this.properties.getRouteId()).with(WellKnownKey.SERVICE_NAME, destServiceName)).build();
            spec.metadata((Object)address, MimeTypes.BROKER_FRAME_MIME_TYPE);
        };
    }

    public Consumer<RSocketRequester.MetadataSpec<?>> address(Consumer<Address.Builder> builderConsumer) {
        return spec -> {
            Address.Builder builder = Address.from((Id)this.properties.getRouteId());
            builderConsumer.accept(builder);
            spec.metadata((Object)builder.build(), MimeTypes.BROKER_FRAME_MIME_TYPE);
        };
    }
}

